/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.MultiarrayInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JArrayInitializer;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JNewArrayExpression
extends JExpression {
    private CArrayType type;
    private JExpression[] dims;
    private JArrayInitializer init;

    public CType getType() {
        return this.type;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        boolean bl = this.analyseDimensions(cExpressionContext);
        try {
            this.type.checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (this.init == null) {
            this.check(cExpressionContext, bl, KjcMessages.MULTIARRAY_BOUND_MISSING);
        } else {
            this.check(cExpressionContext, !bl, KjcMessages.ARRAY_BOUND_AND_INITIALIZER);
            this.init.setType(this.type);
            this.init.analyse(cExpressionContext);
        }
        return this;
    }

    private boolean analyseDimensions(CExpressionContext cExpressionContext) throws PositionedError {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.dims.length) {
            if (this.dims[n] == null) {
                bl = true;
            } else {
                this.check(cExpressionContext, !bl, KjcMessages.MULTIARRAY_BOUND_MISSING);
                this.dims[n] = this.dims[n].analyse(cExpressionContext);
                this.check((CContext)cExpressionContext, this.dims[n].getType().isAssignableTo(CStdType.Integer), KjcMessages.ARRAY_BADTYPE, this.dims[n].getType());
                bl2 = true;
            }
            ++n;
        }
        return bl2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitNewArrayExpression(this, this.type.getBaseType(), this.dims, this.init);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        if (this.init == null) {
            JNewArrayExpression.allocArray(codeSequence, this.type, this.dims);
            if (bl) {
                codeSequence.plantPopInstruction(this.type);
            }
        } else {
            this.init.genCode(codeSequence, bl);
        }
    }

    public static void allocArray(CodeSequence codeSequence, CArrayType cArrayType, JExpression[] jExpressionArray) {
        int n = 0;
        while (n < jExpressionArray.length) {
            if (jExpressionArray[n] != null) {
                jExpressionArray[n].genCode(codeSequence, false);
            }
            ++n;
        }
        if (cArrayType.getArrayBound() > 1) {
            n = 0;
            int n2 = 0;
            while (n2 < jExpressionArray.length && jExpressionArray[n2] != null) {
                ++n;
                ++n2;
            }
            codeSequence.plantInstruction(new MultiarrayInstruction(cArrayType.getSignature(), n));
        } else {
            codeSequence.plantNewArrayInstruction(cArrayType.getElementType());
        }
    }

    public JNewArrayExpression(TokenReference tokenReference, CType cType, JExpression[] jExpressionArray, JArrayInitializer jArrayInitializer) {
        super(tokenReference);
        this.type = new CArrayType(cType, jExpressionArray.length);
        this.dims = jExpressionArray;
        this.init = jArrayInitializer;
    }
}

