/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JBreakStatement
extends JStatement {
    private final String label;
    private JStatement target;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        if (this.label != null) {
            this.target = cBodyContext.getLabeledStatement(this.label);
            this.check((CContext)cBodyContext, this.target != null, KjcMessages.LABEL_UNKNOWN, this.label);
        } else {
            this.target = cBodyContext.getNearestBreakableStatement();
            this.check(cBodyContext, this.target != null, KjcMessages.CANNOT_BREAK);
        }
        cBodyContext.addBreak(this.target);
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitBreakStatement(this, this.label);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        codeSequence.plantBreak(this.target);
        codeSequence.plantJumpInstruction(167, this.target.getBreakLabel());
        this.target = null;
    }

    public JBreakStatement(TokenReference tokenReference, String string, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.label = string;
    }
}

