/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.Utils;

public class JArrayInitializer
extends JExpression {
    private CArrayType type;
    private JExpression[] elems;

    public CType getType() {
        return this.type;
    }

    public void setType(CArrayType cArrayType) {
        Utils.assert(cArrayType.checked());
        this.type = cArrayType;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        Utils.assert(this.type != null);
        CType cType = this.type.getElementType();
        if (cType.isArrayType()) {
            int n = 0;
            while (n < this.elems.length) {
                if (this.elems[n] instanceof JArrayInitializer) {
                    ((JArrayInitializer)this.elems[n]).setType((CArrayType)cType);
                }
                this.elems[n] = this.elems[n].analyse(cExpressionContext);
                this.check(cExpressionContext, this.elems[n].isAssignableTo(cType), KjcMessages.ARRAY_INIT_BADTYPE, cType, this.elems[n].getType());
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.elems.length) {
                this.check((CContext)cExpressionContext, !(this.elems[n] instanceof JArrayInitializer), KjcMessages.ARRAY_INIT_NOARRAY, cType);
                this.elems[n] = this.elems[n].analyse(cExpressionContext);
                this.check(cExpressionContext, this.elems[n].isAssignableTo(cType), KjcMessages.ARRAY_INIT_BADTYPE, cType, this.elems[n].getType());
                this.elems[n] = this.elems[n].convertType(cType, cExpressionContext);
                ++n;
            }
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitArrayInitializer(this, this.elems);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        codeSequence.plantInstruction(new PushLiteralInstruction(this.elems.length));
        codeSequence.plantNewArrayInstruction(this.type.getElementType());
        int n = this.type.getElementType().getArrayStoreOpcode();
        int n2 = 0;
        while (n2 < this.elems.length) {
            codeSequence.plantNoArgInstruction(89);
            codeSequence.plantInstruction(new PushLiteralInstruction(n2));
            this.elems[n2].genCode(codeSequence, false);
            codeSequence.plantNoArgInstruction(n);
            ++n2;
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.getType());
        }
    }

    public JArrayInitializer(TokenReference tokenReference, JExpression[] jExpressionArray) {
        super(tokenReference);
        this.elems = jExpressionArray;
    }
}

