/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.TokenReference;
import at.dms.kjc.CClassContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CMethodContext;
import at.dms.kjc.CSimpleBodyContext;
import at.dms.kjc.CThrowableInfo;
import at.dms.kjc.CVariableInfo;
import at.dms.kjc.JExpression;
import at.dms.kjc.JStatement;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CBodyContext
extends CContext {
    private static final Hashtable EMPTY = new Hashtable(1);
    private static final int FLO_UNREACHABLE = 1;
    private static final int FLO_BREAKED = 2;
    private static final int FLO_CONTINUED = 4;
    private static final int FLO_INLOOP = 8;
    private int flowState;
    private CVariableInfo variableInfo;
    private CVariableInfo fieldInfo;
    private Hashtable throwables;

    public final CSimpleBodyContext cloneContext() {
        return new CSimpleBodyContext(this, this);
    }

    public void close(TokenReference tokenReference) {
        this.informParent();
    }

    private void informParent() {
        int n;
        int n2;
        if (this.parent instanceof CBodyContext) {
            CBodyContext cBodyContext = (CBodyContext)this.parent;
            if (this.variableInfo != null) {
                n2 = cBodyContext.getBlockContext().localsIndex();
                n = 0;
                while (n < n2) {
                    int n3 = this.variableInfo.getInfo(n);
                    if (n3 != 0) {
                        cBodyContext.setVariableInfo(n, n3);
                    }
                    ++n;
                }
            }
            cBodyContext.adoptFlowState(this);
        }
        if (this.fieldInfo != null) {
            int n4 = this.parent.getClassContext().getCClass().getFieldCount();
            n2 = 0;
            while (n2 < n4) {
                n = this.fieldInfo.getInfo(n2);
                if (n != 0) {
                    this.parent.setFieldInfo(n2, n);
                }
                ++n2;
            }
        }
    }

    public void merge(CBodyContext cBodyContext) {
        this.mergeFlowState(cBodyContext);
        this.mergeVariableInfos(cBodyContext);
        this.mergeFieldInfos(cBodyContext);
    }

    public void adopt(CBodyContext cBodyContext) {
        this.adoptFlowState(cBodyContext);
        this.adoptVariableInfos(cBodyContext);
        this.adoptFieldInfos(cBodyContext);
    }

    public void adoptFlowState(CBodyContext cBodyContext) {
        this.flowState = cBodyContext.flowState;
    }

    public void mergeFlowState(CBodyContext cBodyContext) {
        this.flowState &= cBodyContext.flowState;
    }

    public void adoptVariableInfos(CBodyContext cBodyContext) {
        int n = this.getBlockContext().localsIndex();
        int n2 = 0;
        while (n2 < n) {
            int n3 = cBodyContext.getVariableInfo(n2);
            if (n3 != 0) {
                this.setVariableInfo(n2, n3);
            }
            ++n2;
        }
    }

    public void mergeVariableInfos(CBodyContext cBodyContext) {
        if (this.variableInfo != null || cBodyContext.variableInfo != null) {
            int n = this.getBlockContext().localsIndex();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = this.getVariableInfo(n2);
                if (n4 + (n3 = cBodyContext.getVariableInfo(n2)) != 0) {
                    if (this.variableInfo == null) {
                        this.variableInfo = this.getVariableInfo();
                    }
                    this.variableInfo.setInfo(n2, CVariableInfo.merge(n4, n3));
                }
                ++n2;
            }
        }
    }

    public void adoptFieldInfos(CContext cContext) {
        int n = this.parent.getClassContext().getCClass().getFieldCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = cContext.getFieldInfo(n2);
            if (n3 != 0) {
                this.setFieldInfo(n2, n3);
            }
            ++n2;
        }
    }

    public void mergeFieldInfos(CBodyContext cBodyContext) {
        if (this.fieldInfo != null || cBodyContext.fieldInfo != null) {
            int n = this.parent.getClassContext().getCClass().getFieldCount();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = this.getFieldInfo(n2);
                if (n4 + (n3 = cBodyContext.getFieldInfo(n2)) != 0) {
                    if (this.fieldInfo == null) {
                        this.fieldInfo = this.getFieldInfo();
                    }
                    this.fieldInfo.setInfo(n2, CVariableInfo.merge(n4, n3));
                }
                ++n2;
            }
        }
    }

    public JExpression lookupOuterLocalVariable(TokenReference tokenReference, String string) {
        CClassContext cClassContext = this.getClassContext();
        return cClassContext.lookupOuterLocalVariable(tokenReference, string);
    }

    public void clearFlowState() {
        this.flowState = 0;
    }

    public void setInLoop(boolean bl) {
        this.flowState = bl ? (this.flowState |= 8) : (this.flowState &= 0xFFFFFFF7);
    }

    public boolean isInLoop() {
        return (this.flowState & 8) != 0;
    }

    public void setReachable(boolean bl) {
        this.flowState = bl ? (this.flowState &= 0xFFFFFFFE) : (this.flowState |= 1);
    }

    public boolean isReachable() {
        return (this.flowState & 1) == 0;
    }

    public void addBreak(JStatement jStatement) {
        this.addBreak(jStatement, this);
        this.flowState |= 3;
    }

    protected void addBreak(JStatement jStatement, CBodyContext cBodyContext) {
        ((CBodyContext)this.getParentContext()).addBreak(jStatement, cBodyContext);
    }

    public boolean isBreaked() {
        return (this.flowState & 2) != 0;
    }

    public void addContinue(JStatement jStatement) {
        this.addContinue(jStatement, this);
        this.flowState |= 5;
    }

    protected void addContinue(JStatement jStatement, CBodyContext cBodyContext) {
        ((CBodyContext)this.getParentContext()).addContinue(jStatement, cBodyContext);
    }

    public boolean isContinued() {
        return (this.flowState & 4) != 0;
    }

    public int localsPosition() {
        return ((CBodyContext)this.parent).localsPosition();
    }

    public JStatement getLabeledStatement(String string) {
        return this.parent instanceof CBodyContext ? ((CBodyContext)this.parent).getLabeledStatement(string) : null;
    }

    public JStatement getNearestBreakableStatement() {
        return this.parent instanceof CBodyContext ? ((CBodyContext)this.parent).getNearestBreakableStatement() : null;
    }

    public JStatement getNearestContinuableStatement() {
        return this.parent instanceof CBodyContext ? ((CBodyContext)this.parent).getNearestContinuableStatement() : null;
    }

    protected CVariableInfo getVariableInfo() {
        if (this.variableInfo != null) {
            return this.variableInfo;
        }
        if (this.parent instanceof CBodyContext) {
            return ((CBodyContext)this.parent).getVariableInfo();
        }
        return new CVariableInfo();
    }

    public void setVariableInfo(int n, int n2) {
        if (this.variableInfo == null) {
            this.variableInfo = (CVariableInfo)this.getVariableInfo().clone();
        }
        this.variableInfo.setInfo(n, n2);
    }

    public int getVariableInfo(int n) {
        if (this.variableInfo != null) {
            return this.variableInfo.getInfo(n);
        }
        if (this.parent instanceof CBodyContext) {
            return ((CBodyContext)this.parent).getVariableInfo(n);
        }
        return 0;
    }

    public void setFieldInfo(int n, int n2) {
        if (this.fieldInfo == null) {
            this.fieldInfo = (CVariableInfo)this.getFieldInfo().clone();
        }
        this.fieldInfo.setInfo(n, n2);
    }

    public int getFieldInfo(int n) {
        if (this.fieldInfo == null) {
            return this.parent.getFieldInfo(n);
        }
        return this.fieldInfo.getInfo(n);
    }

    public CVariableInfo getFieldInfo() {
        if (this.fieldInfo != null) {
            return this.fieldInfo;
        }
        return this.parent.getFieldInfo();
    }

    public void clearThrowables() {
        this.throwables = new Hashtable();
    }

    public void addThrowable(CThrowableInfo cThrowableInfo) {
        if (this.throwables == null) {
            this.throwables = new Hashtable();
        }
        this.throwables.put(cThrowableInfo, cThrowableInfo);
    }

    public void mergeThrowables(CBodyContext cBodyContext) {
        Enumeration enumeration = cBodyContext.getThrowables().elements();
        while (enumeration.hasMoreElements()) {
            this.addThrowable((CThrowableInfo)enumeration.nextElement());
        }
    }

    public void adoptThrowables(CBodyContext cBodyContext) {
        this.throwables = new Hashtable();
        this.mergeThrowables(cBodyContext);
    }

    public Hashtable getThrowables() {
        return this.throwables == null ? EMPTY : this.throwables;
    }

    public void dumpContext(int n) {
        int n2;
        this.dumpIndent(n);
        System.err.println(this + " " + this.getBlockContext().localsIndex());
        this.dumpIndent(n);
        System.err.println("info: " + ((this.flowState & 1) != 0 ? "unreach " : "") + ((this.flowState & 2) != 0 ? "breaked " : "") + ((this.flowState & 4) != 0 ? "contind " : "") + ((this.flowState & 8) != 0 ? "inloop  " : ""));
        this.dumpIndent(n);
        System.err.print("vars: ");
        if (this.variableInfo == null) {
            System.err.print("---");
        } else {
            n2 = 0;
            while (n2 < 8) {
                System.err.print(" " + n2 + ":" + this.getVariableInfo(n2));
                ++n2;
            }
        }
        this.dumpIndent(n);
        System.err.println("");
        this.dumpIndent(n);
        System.err.print("flds: ");
        if (this.fieldInfo == null) {
            System.err.print("---");
        } else {
            n2 = 0;
            while (n2 < 8) {
                System.err.print(" " + n2 + ":" + this.getFieldInfo(n2));
                ++n2;
            }
        }
        this.dumpIndent(n);
        System.err.println("");
        this.dumpIndent(n);
        System.err.print("excp: ");
        if (this.throwables == null) {
            System.err.print("---");
        } else {
            Enumeration enumeration = this.throwables.elements();
            while (enumeration.hasMoreElements()) {
                System.err.print(" " + ((CThrowableInfo)enumeration.nextElement()).getThrowable());
            }
        }
        this.dumpIndent(n);
        System.err.println("");
        if (this.parent != null) {
            this.parent.dumpContext(n + 1);
        }
    }

    protected CBodyContext(CBodyContext cBodyContext) {
        super(cBodyContext);
        this.flowState = cBodyContext.flowState;
        this.variableInfo = null;
        this.fieldInfo = null;
        this.throwables = cBodyContext.throwables;
    }

    protected CBodyContext(CMethodContext cMethodContext) {
        super(cMethodContext);
        this.flowState = 0;
        this.variableInfo = null;
        this.fieldInfo = null;
        this.throwables = cMethodContext.getThrowables();
    }

    protected CBodyContext(CBodyContext cBodyContext, CBodyContext cBodyContext2) {
        super(cBodyContext);
        this.flowState = cBodyContext2.flowState;
        this.variableInfo = (CVariableInfo)cBodyContext2.getVariableInfo().clone();
        this.fieldInfo = (CVariableInfo)cBodyContext2.getFieldInfo().clone();
        this.throwables = cBodyContext.throwables;
    }
}

