/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.FileCopyException;
import at.dms.compiler.tools.antlr.runtime.FileLineFormatter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class Utils
extends at.dms.util.Utils {
    public static File getParent(File file) {
        String string = file.getParent();
        if (string == null) {
            string = file.isAbsolute() ? File.separator : System.getProperty("user.dir");
        }
        return new File(string);
    }

    public static String pathToFile(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return "." + string2;
        }
        return string.substring(0, n + 1);
    }

    public static String fileMinusPath(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter;
        block17: {
            File file = new File(string);
            File file2 = new File(string2);
            InputStreamReader inputStreamReader = null;
            outputStreamWriter = null;
            try {
                int n;
                Object object;
                if (!file.exists() || !file.isFile()) {
                    throw new FileCopyException("FileCopy: no such source file: " + string);
                }
                if (!file.canRead()) {
                    throw new FileCopyException("FileCopy: source file is unreadable: " + string);
                }
                if (file2.exists()) {
                    if (!file2.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + string2);
                    object = new DataInputStream(System.in);
                    if (!file2.canWrite()) {
                        throw new FileCopyException("FileCopy: destination file is unwriteable: " + string2);
                    }
                } else {
                    object = Utils.getParent(file2);
                    if (!((File)object).exists()) {
                        throw new FileCopyException("FileCopy: destination directory doesn't exist: " + string2);
                    }
                    if (!((File)object).canWrite()) {
                        throw new FileCopyException("FileCopy: destination directory is unwriteable: " + string2);
                    }
                }
                inputStreamReader = new FileReader(file);
                outputStreamWriter = new FileWriter(file2);
                char[] cArray = new char[1024];
                while ((n = inputStreamReader.read(cArray, 0, 1024)) != -1) {
                    outputStreamWriter.write(cArray, 0, n);
                }
                Object var8_12 = null;
                if (inputStreamReader == null) break block17;
            }
            catch (Throwable throwable) {
                IOException iOException2;
                Object var8_13 = null;
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (outputStreamWriter == null) throw throwable;
                try {
                    outputStreamWriter.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static String stripBack(String string, char c) {
        while (string.length() > 0 && string.charAt(string.length() - 1) == c) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String stripBack(String string, String string2) {
        boolean bl;
        do {
            bl = false;
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                while (string.length() > 0 && string.charAt(string.length() - 1) == c) {
                    bl = true;
                    string = string.substring(0, string.length() - 1);
                }
                ++n;
            }
        } while (bl);
        return string;
    }

    public static String stripFront(String string, char c) {
        while (string.length() > 0 && string.charAt(0) == c) {
            string = string.substring(1);
        }
        return string;
    }

    public static String stripFront(String string, String string2) {
        boolean bl;
        do {
            bl = false;
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                while (string.length() > 0 && string.charAt(0) == c) {
                    bl = true;
                    string = string.substring(1);
                }
                ++n;
            }
        } while (bl);
        return string;
    }

    public static String stripFrontBack(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        int n2 = string.lastIndexOf(string3);
        if (n == -1 || n2 == -1) {
            return string;
        }
        return string.substring(n + 1, n2);
    }

    public static void panic() {
        Utils.panic("");
    }

    public static void panic(String string) {
        System.err.println("panic: " + string);
        System.exit(1);
    }

    public static void toolError(String string) {
        System.err.println("error: " + string);
    }

    public static void warning(String string) {
        System.err.println("warning: " + string);
    }

    public static void warning(String string, String string2, int n) {
        if (string2 != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(string2, n) + "warning:" + string);
        } else {
            System.err.println("warning; line " + n + ": " + string);
        }
    }

    public static void warning(String[] stringArray, String string, int n) {
        if (stringArray == null || stringArray.length == 0) {
            Utils.panic("bad multi-line message to Tool.warning");
        }
        if (string != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(string, n) + "warning:" + stringArray[0]);
            int n2 = 1;
            while (n2 < stringArray.length) {
                System.err.println(FileLineFormatter.getFormatter().getFormatString(string, n) + stringArray[n2]);
                ++n2;
            }
        } else {
            System.err.println("warning: line " + n + ": " + stringArray[0]);
            int n3 = 1;
            while (n3 < stringArray.length) {
                System.err.println("warning: line " + n + ": " + stringArray[n3]);
                ++n3;
            }
        }
    }

    public static void setFileLineFormatter(FileLineFormatter fileLineFormatter) {
        FileLineFormatter.setFormatter(fileLineFormatter);
    }
}

