/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import java.io.DataOutput;
import java.io.IOException;

public class IincInstruction
extends Instruction {
    private int var;
    private int inc;

    public boolean canComplete() {
        return true;
    }

    void resolveConstants(ConstantPool constantPool) {
    }

    int getSize() {
        return 1 + (this.isWide() ? 5 : 2);
    }

    public int getIncrement() {
        return this.inc;
    }

    public int getVariable() {
        return this.var;
    }

    public byte getReturnType() {
        return 4;
    }

    public int getPushedOnStack() {
        return 0;
    }

    public int getStack() {
        return 0;
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        if (this.isWide()) {
            dataOutput.writeByte(-60);
        }
        dataOutput.writeByte((byte)this.getOpcode());
        if (this.isWide()) {
            dataOutput.writeShort((short)(this.var & 0xFFFF));
            dataOutput.writeShort((short)(this.inc & 0xFFFF));
        } else {
            dataOutput.writeByte((byte)(this.var & 0xFF));
            dataOutput.writeByte((byte)(this.inc & 0xFF));
        }
    }

    private boolean isWide() {
        return this.var > 255 || this.inc > 127 || this.inc < -128;
    }

    public IincInstruction(int n, int n2) {
        super(132);
        this.var = n;
        this.inc = n2;
    }
}

