/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.CodeSequence;
import at.dms.backend.InstructionHandle;
import at.dms.backend.QDestination;
import at.dms.backend.QOperand;
import at.dms.backend.QOrigin;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.util.InconsistencyException;

class QTemporary
extends QOperand
implements QDestination {
    private static int _count;
    public static final int UNINITIALIZED = -1;
    public static final int UNUSED = -2;
    public static final QTemporary[] EMPTY;
    private int type;
    private BasicBlock defBlock;
    private int defPos;
    private BasicBlock useBlock;
    private int usePos;
    private int countUses;
    private int register = -1;
    private int precolor = Integer.MAX_VALUE;
    private boolean usePrecolor;
    private int pos;

    public QTemporary getDef() {
        return null;
    }

    public QTemporary[] getUses() {
        return new QTemporary[]{this};
    }

    public int getSize() {
        return InstructionHandle.getTypeSize(this.type);
    }

    public int getRegister() {
        return this.register;
    }

    public int getPrecolor() {
        return this.usePrecolor && Integer.MAX_VALUE != this.precolor ? this.precolor : -1;
    }

    public void enforceColor() {
        this.usePrecolor = true;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        int n;
        int n2 = n = this.register == -1 ? this.pos : this.register;
        if (this.precolor != Integer.MAX_VALUE) {
            if (this.usePrecolor) {
                return "P_" + this.precolor;
            }
            return "L_" + this.precolor;
        }
        return "t_" + n;
    }

    public QOrigin duplicate() {
        return this;
    }

    public void use(BasicBlock basicBlock, int n) {
        this.useBlock = basicBlock;
        this.usePos = n;
        ++this.countUses;
    }

    public void def(BasicBlock basicBlock, int n) {
        this.defBlock = basicBlock;
        this.defPos = n;
    }

    public int getUseCount() {
        return this.countUses;
    }

    public void setPosition(int n) {
        this.pos = n;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setRegister(int n) {
        this.register = this.countUses == 0 ? -2 : n;
    }

    public void generate(CodeSequence codeSequence) {
        if (this.register != -2) {
            int n;
            switch (this.getType()) {
                case 6: {
                    n = 25;
                    break;
                }
                case 2: {
                    n = 24;
                    break;
                }
                case 3: {
                    n = 23;
                    break;
                }
                case 4: {
                    n = 21;
                    break;
                }
                case 5: {
                    n = 22;
                    break;
                }
                default: {
                    throw new InconsistencyException();
                }
            }
            codeSequence.plantInstruction(new LocalVarInstruction(n, this.register));
        } else if (this.countUses == 0) {
            throw new InconsistencyException();
        }
    }

    public void store(CodeSequence codeSequence, boolean bl) {
        if (this.register != -2 && bl) {
            int n;
            switch (this.getType()) {
                case 6: {
                    n = 58;
                    break;
                }
                case 2: {
                    n = 57;
                    break;
                }
                case 3: {
                    n = 56;
                    break;
                }
                case 4: {
                    n = 54;
                    break;
                }
                case 5: {
                    n = 55;
                    break;
                }
                default: {
                    throw new InconsistencyException();
                }
            }
            codeSequence.plantInstruction(new LocalVarInstruction(n, this.register));
        } else if (this.countUses == 0 || !bl) {
            int n = InstructionHandle.getTypeSize(this.type);
            codeSequence.plantInstruction(new NoArgInstruction(n == 1 ? 87 : 88));
        }
    }

    QTemporary(int n) {
        this.type = n;
        this.pos = _count++;
    }

    QTemporary(int n, int n2) {
        this(n);
        this.precolor = n2;
    }

    static {
        EMPTY = new QTemporary[0];
    }
}

