/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.CodeSequence;
import at.dms.backend.InstructionHandle;
import at.dms.backend.MethodEnv;
import at.dms.backend.QDestination;
import at.dms.backend.QIinc;
import at.dms.backend.QJump;
import at.dms.backend.QLiteral;
import at.dms.backend.QNode;
import at.dms.backend.QOperand;
import at.dms.backend.QOperator;
import at.dms.backend.QOrigin;
import at.dms.backend.QStack;
import at.dms.backend.QTemporary;
import at.dms.backend.QVoid;
import at.dms.classfile.IincInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Stack;
import java.util.Vector;

class QQuadruple
extends QNode
implements QOrigin {
    private QDestination dest;
    private QOrigin origin;
    private static /* synthetic */ Class class$Lat$dms$backend$QOperand;

    public boolean isStore() {
        return true;
    }

    public QQuadruple getStore() {
        return this;
    }

    public String toString() {
        return this.dest + " <- " + this.origin;
    }

    public int getType() {
        return 0;
    }

    public QOrigin duplicate() {
        throw new InconsistencyException("NYI");
    }

    public void useStack() {
        this.dest = new QStack(((QTemporary)this.dest).getType());
    }

    public QOrigin[] getOrigins() {
        return this.origin.getOrigins();
    }

    public void setOrigin(QOrigin qOrigin, int n) {
        if (this.origin instanceof QOperator) {
            this.origin.setOrigin(qOrigin, n);
        } else if (n == 0) {
            this.origin = qOrigin;
        } else {
            throw new InconsistencyException();
        }
    }

    public QTemporary getDef() {
        return (QTemporary)this.dest;
    }

    public QTemporary[] getUses() {
        return this.origin.getUses();
    }

    public void generate(CodeSequence codeSequence) {
        this.origin.generate(codeSequence);
        if (this.dest instanceof QTemporary) {
            this.dest.store(codeSequence, this.isLive((QTemporary)this.dest));
        } else {
            this.dest.store(codeSequence, true);
        }
    }

    public static QTemporary[] buildQuadruples(MethodEnv methodEnv, BasicBlock basicBlock, InstructionHandle[] instructionHandleArray, QTemporary[] qTemporaryArray, Vector vector) {
        QOrigin qOrigin;
        QOrigin[] qOriginArray;
        InstructionHandle instructionHandle;
        Stack<Object> stack = new Stack<Object>();
        int n = 0;
        while (qTemporaryArray != null && n < qTemporaryArray.length) {
            stack.push(qTemporaryArray[n]);
            ++n;
        }
        n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandle = instructionHandleArray[n];
            if (instructionHandle.getInstruction() instanceof LocalVarInstruction) {
                if (instructionHandle.getLocal().isLoad()) {
                    qOriginArray = methodEnv.getLocalVar(instructionHandle);
                    stack.push(qOriginArray);
                } else {
                    qOriginArray = (QOrigin)stack.pop();
                    qOrigin = methodEnv.getLocalVar(instructionHandle);
                    vector.addElement(new QQuadruple((QDestination)((Object)qOrigin), (QOrigin)qOriginArray));
                }
            } else if (instructionHandle.getInstruction() instanceof PushLiteralInstruction) {
                stack.push(new QLiteral(instructionHandle));
            } else if (instructionHandle.isPop()) {
                vector.addElement(new QQuadruple(new QTemporary(1), (QOrigin)stack.pop()));
            } else if (instructionHandle.isDup()) {
                qOriginArray = stack.pop();
                stack.push(qOriginArray);
                stack.push(((QOrigin)qOriginArray).duplicate());
            } else if (instructionHandle.isDupX2()) {
                qOriginArray = stack.pop();
                qOrigin = stack.pop();
                stack.push(qOrigin);
                stack.push(qOriginArray);
                stack.push(qOrigin.duplicate());
            } else if (instructionHandle.isSwap()) {
                qOriginArray = stack.pop();
                qOrigin = stack.pop();
                stack.push(qOriginArray);
                stack.push(qOrigin);
            } else if (instructionHandle.getInstruction() instanceof IincInstruction) {
                vector.addElement(new QIinc(instructionHandle.getInstruction(), methodEnv.getLocalVar(((IincInstruction)instructionHandle.getInstruction()).getVariable())));
            } else {
                QTemporary qTemporary;
                qOriginArray = QQuadruple.readOperands(stack, instructionHandle.countOperands());
                if (instructionHandle.isJump()) {
                    vector.addElement(new QJump(new QOperator(instructionHandle, qOriginArray)));
                } else if (!instructionHandle.hasReturnValue()) {
                    vector.addElement(new QVoid(new QOperator(instructionHandle, qOriginArray)));
                } else if (n != instructionHandleArray.length - 1 && instructionHandleArray[n + 1].getInstruction() instanceof LocalVarInstruction && instructionHandleArray[n + 1].getLocal().isStore()) {
                    qOrigin = new QOperator(instructionHandle, qOriginArray);
                    qTemporary = methodEnv.getLocalVar(instructionHandleArray[n + 1]);
                    vector.addElement(new QQuadruple(qTemporary, qOrigin));
                    ++n;
                } else {
                    qOrigin = new QOperator(instructionHandle, qOriginArray);
                    qTemporary = new QTemporary(((QOperator)qOrigin).getType());
                    vector.addElement(new QQuadruple(qTemporary, qOrigin));
                    stack.push(qTemporary);
                }
            }
            ++n;
        }
        n = 0;
        InstructionHandle instructionHandle2 = instructionHandle = vector.size() == 0 ? null : (QNode)vector.elementAt(vector.size() - 1);
        if (instructionHandle instanceof QJump) {
            vector.setSize(vector.size() - 1);
        }
        qOriginArray = new QTemporary[stack.size()];
        while (stack.size() > 0) {
            qOrigin = (QOrigin)stack.pop();
            if (qOrigin instanceof QTemporary) {
                qOriginArray[n++] = qOrigin;
                continue;
            }
            qOriginArray[n] = new QTemporary(qOrigin.getType());
            vector.addElement(new QQuadruple(qOriginArray[n++], qOrigin));
        }
        if (instructionHandle instanceof QJump) {
            vector.addElement(instructionHandle);
        }
        return qOriginArray;
    }

    private static QOperand[] readOperands(Stack stack, int n) {
        Vector<QOperand> vector = new Vector<QOperand>();
        int n2 = 0;
        while (n > 0) {
            QOperand qOperand = (QOperand)stack.pop();
            n -= InstructionHandle.getTypeSize(qOperand.getType());
            vector.addElement(qOperand);
            ++n2;
        }
        return (QOperand[])Utils.toArray(vector, class$Lat$dms$backend$QOperand != null ? class$Lat$dms$backend$QOperand : (class$Lat$dms$backend$QOperand = QQuadruple.class$("at.dms.backend.QOperand")));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public QQuadruple(QDestination qDestination, QOrigin qOrigin) {
        this.dest = qDestination;
        this.origin = qOrigin;
    }
}

