/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;

public abstract class JComponent
extends Container
implements Serializable {
    protected AccessibleContext accessibleContext;
    Dimension pref;
    Dimension min;
    Dimension max;
    Border border;
    JToolTip tooltip;
    String tool_tip_text;
    boolean use_double_buffer;
    boolean opaque;
    protected ComponentUI ui;
    Vector ancestor_list;
    Vector veto_list;
    Vector change_list;
    Hashtable prop_hash;

    public JComponent() {
        super.setLayout(new FlowLayout());
        this.enableEvents(8);
    }

    public boolean contains(int x, int y) {
        return super.contains(x, y);
    }

    public void addNotify() {
        super.addNotify();
    }

    Hashtable get_prop_hash() {
        if (this.prop_hash == null) {
            this.prop_hash = new Hashtable();
        }
        return this.prop_hash;
    }

    public Vector get_veto_list() {
        if (this.veto_list == null) {
            this.veto_list = new Vector();
        }
        return this.veto_list;
    }

    public Vector get_change_list() {
        if (this.change_list == null) {
            this.change_list = new Vector();
        }
        return this.change_list;
    }

    public Vector get_ancestor_list() {
        if (this.ancestor_list == null) {
            this.ancestor_list = new Vector();
        }
        return this.ancestor_list;
    }

    public Object getClientProperty(Object key) {
        return this.get_prop_hash().get(key);
    }

    public void putClientProperty(Object key, Object value) {
        this.get_prop_hash().put(key, value);
    }

    public void removeAncestorListener(AncestorListener listener) {
        this.get_ancestor_list().removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.get_change_list().removeElement(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.get_change_list().removeElement(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.get_veto_list().removeElement(listener);
    }

    public void addAncestorListener(AncestorListener listener) {
        this.get_ancestor_list().addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.get_change_list().addElement(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.get_change_list().addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.get_veto_list().addElement(listener);
    }

    public void computeVisibleRect(Rectangle rect) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public ActionListener getActionForKeyStroke(KeyStroke aKeyStroke) {
        return null;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public boolean getAutoscrolls() {
        return false;
    }

    public void setBorder(Border border) {
        this.border = border;
        this.revalidate();
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rv) {
        if (rv == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rv.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rv;
    }

    protected Graphics getComponentGraphics(Graphics g) {
        return g;
    }

    public int getConditionForKeyStroke(KeyStroke aKeyStroke) {
        return 0;
    }

    public int getDebugGraphicsOptions() {
        return 0;
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets t = this.getInsets();
        if (insets == null) {
            return t;
        }
        return new Insets(t.top, t.left, t.bottom, t.right);
    }

    public Point getLocation(Point rv) {
        if (rv == null) {
            return new Point(this.getX(), this.getY());
        }
        rv.setLocation(this.getX(), this.getY());
        return rv;
    }

    public Dimension getMaximumSize() {
        Dimension p;
        Dimension s;
        if (this.max != null) {
            return this.max;
        }
        if (this.ui != null && (s = this.ui.getMaximumSize(this)) != null) {
            return p;
        }
        p = super.getMaximumSize();
        return p;
    }

    public Dimension getMinimumSize() {
        Dimension p;
        Dimension s;
        if (this.min != null) {
            return this.min;
        }
        if (this.ui != null && (s = this.ui.getMinimumSize(this)) != null) {
            return p;
        }
        p = super.getMinimumSize();
        return p;
    }

    public Dimension getPreferredSize() {
        Dimension p;
        Dimension s;
        if (this.pref != null) {
            return this.pref;
        }
        if (this.ui != null && (s = this.ui.getPreferredSize(this)) != null) {
            return p;
        }
        p = super.getPreferredSize();
        return p;
    }

    public Component getNextFocusableComponent() {
        return null;
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return null;
    }

    public JRootPane getRootPane() {
        JRootPane p = SwingUtilities.getRootPane(this);
        System.out.println("root = " + p);
        return p;
    }

    public Dimension getSize(Dimension rv) {
        if (rv == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        rv.setSize(this.getWidth(), this.getHeight());
        return rv;
    }

    public JToolTip createToolTip() {
        if (this.tooltip == null) {
            this.tooltip = new JToolTip(this.tool_tip_text);
        }
        return this.tooltip;
    }

    public Point getToolTipLocation(MouseEvent event) {
        return null;
    }

    public void setToolTipText(String text) {
        this.tool_tip_text = text;
    }

    public String getToolTipText() {
        return this.tool_tip_text;
    }

    public String getToolTipText(MouseEvent event) {
        return this.tool_tip_text;
    }

    public Container getTopLevelAncestor() {
        System.out.println("JComponent, getTopLevelAncestor()");
        return null;
    }

    public Rectangle getVisibleRect() {
        System.out.println("JComponent, getVisibleRect()");
        return null;
    }

    public void grabFocus() {
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isDoubleBuffered() {
        return this.use_double_buffer;
    }

    public boolean isFocusCycleRoot() {
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public static boolean isLightweightComponent(Component c) {
        return c.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public void paint(Graphics g) {
        this.paintBorder(g);
        this.paintComponent(g);
        this.paintChildren(g);
    }

    protected void paintBorder(Graphics g) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintChildren(Graphics g) {
    }

    protected void paintComponent(Graphics g) {
        if (this.ui != null) {
            this.ui.paint(g, this);
        }
    }

    public void paintImmediately(int x, int y, int w, int h) {
    }

    public void paintImmediately(Rectangle r) {
        this.paintImmediately((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    protected String paramString() {
        return "JComponent";
    }

    protected void processComponentKeyEvent(KeyEvent e) {
    }

    protected void processFocusEvent(FocusEvent e) {
    }

    protected void processKeyEvent(KeyEvent e) {
    }

    public void processMouseMotionEvent(MouseEvent e) {
    }

    public void registerKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
        this.registerKeyboardAction(anAction, null, aKeyStroke, aCondition);
    }

    public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
    }

    public void removeNotify() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    public void repaint(Rectangle r) {
        this.repaint(0L, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    public void resetKeyboardActions() {
    }

    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
    }

    public void revalidate() {
        if (this.getParent() == null) {
            this.invalidate();
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
    }

    public void setAlignmentX(float alignmentX) {
    }

    public void setAlignmentY(float alignmentY) {
    }

    public void setAutoscrolls(boolean autoscrolls) {
    }

    public void setDebugGraphicsOptions(int debugOptions) {
    }

    public void setDoubleBuffered(boolean aFlag) {
        this.use_double_buffer = aFlag;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.revalidate();
        this.repaint();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.revalidate();
        this.repaint();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.revalidate();
        this.repaint();
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.max = maximumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.min = minimumSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.pref = preferredSize;
    }

    public void setNextFocusableComponent(Component aComponent) {
    }

    public void setOpaque(boolean isOpaque) {
        this.opaque = isOpaque;
        this.revalidate();
        this.repaint();
    }

    public void setRequestFocusEnabled(boolean aFlag) {
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (this.getParent() != null) {
            Rectangle dims = this.getBounds();
            this.getParent().repaint((int)dims.getX(), (int)dims.getY(), (int)dims.getWidth(), (int)dims.getHeight());
        }
    }

    public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public String getUIClassID() {
        return "JComponent";
    }

    protected void setUI(ComponentUI newUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        this.ui = newUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        System.out.println("update UI not overwritten in class: " + this);
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer {
        private /* synthetic */ JComponent this$0;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent(JComponent this$0, JComponent component) {
            this.this$0 = this$0;
            super(this$0);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public String getAccessibleName() {
            return null;
        }

        public String getAccessibleDescription() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        protected String getBorderTitle(Border value0) {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleContainerHandler(AccessibleJComponent this$1, AccessibleJComponent component) {
                this.this$1 = this$1;
            }

            public void componentAdded(ContainerEvent event) {
            }

            public void componentRemoved(ContainerEvent valevent) {
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleFocusHandler(AccessibleJComponent this$1, AccessibleJComponent component) {
                this.this$1 = this$1;
            }

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent valevent) {
            }
        }
    }
}

