/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ksm;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.SwitchInstruction;
import at.dms.ksm.KsmError;
import at.dms.ksm.KsmMessages;
import at.dms.ksm.LabelReference;
import at.dms.ksm.UnresolvableLabelException;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Hashtable;
import java.util.Vector;

public class MethodBody {
    private Vector insns = new Vector();
    private Vector handlers = new Vector();
    private Vector lines = new Vector();
    private Vector variables = new Vector();
    private Hashtable labels = new Hashtable();
    private int lineNumberId = 0;
    private static /* synthetic */ Class class$Lat$dms$classfile$Instruction;
    private static /* synthetic */ Class class$Lat$dms$classfile$HandlerInfo;
    private static /* synthetic */ Class class$Lat$dms$classfile$LineNumberInfo;
    private static /* synthetic */ Class class$Lat$dms$classfile$LocalVariableInfo;

    public void addInstruction(Instruction instruction) {
        this.insns.addElement(instruction);
    }

    public void addLabel(String string) throws KsmError {
        if (this.labels.contains(string)) {
            throw new KsmError(null, KsmMessages.LABEL_REDEFINED, string);
        }
        this.labels.put(string, new Integer(this.insns.size()));
    }

    public void addHandler(String string, LabelReference labelReference, LabelReference labelReference2, LabelReference labelReference3) {
        this.handlers.addElement(new HandlerInfo(labelReference, labelReference2, labelReference3, string));
    }

    public void addLineNumber(int n) {
        String string = "'" + this.lineNumberId++;
        try {
            this.addLabel(string);
        }
        catch (KsmError ksmError) {
            throw new InconsistencyException();
        }
        this.lines.addElement(new LineNumberInfo((short)n, new LabelReference(string)));
    }

    public void addVariable(String string, String string2, LabelReference labelReference, LabelReference labelReference2, short s) {
        this.variables.addElement(new LocalVariableInfo(labelReference, labelReference2, string, string2, s));
    }

    public Instruction resolveLabel(String string) throws UnresolvableLabelException {
        Integer n = (Integer)this.labels.get(string);
        if (n == null) {
            throw new UnresolvableLabelException(KsmMessages.UNDEFINED_LABEL, string);
        }
        if (n >= this.insns.size()) {
            throw new UnresolvableLabelException(KsmMessages.NO_CODE_AT_LABEL, string);
        }
        return (Instruction)this.insns.elementAt(n);
    }

    public CodeInfo genCodeInfo() throws KsmError {
        Instruction[] instructionArray = (Instruction[])Utils.toArray(this.insns, class$Lat$dms$classfile$Instruction != null ? class$Lat$dms$classfile$Instruction : (class$Lat$dms$classfile$Instruction = MethodBody.class$("at.dms.classfile.Instruction")));
        HandlerInfo[] handlerInfoArray = (HandlerInfo[])Utils.toArray(this.handlers, class$Lat$dms$classfile$HandlerInfo != null ? class$Lat$dms$classfile$HandlerInfo : (class$Lat$dms$classfile$HandlerInfo = MethodBody.class$("at.dms.classfile.HandlerInfo")));
        LineNumberInfo[] lineNumberInfoArray = (LineNumberInfo[])Utils.toArray(this.lines, class$Lat$dms$classfile$LineNumberInfo != null ? class$Lat$dms$classfile$LineNumberInfo : (class$Lat$dms$classfile$LineNumberInfo = MethodBody.class$("at.dms.classfile.LineNumberInfo")));
        LocalVariableInfo[] localVariableInfoArray = (LocalVariableInfo[])Utils.toArray(this.variables, class$Lat$dms$classfile$LocalVariableInfo != null ? class$Lat$dms$classfile$LocalVariableInfo : (class$Lat$dms$classfile$LocalVariableInfo = MethodBody.class$("at.dms.classfile.LocalVariableInfo")));
        CodeInfo codeInfo = new CodeInfo(instructionArray, handlerInfoArray, lineNumberInfoArray, localVariableInfoArray);
        try {
            MethodBody methodBody = this;
            if (methodBody == null) {
                throw null;
            }
            AccessorTransformer accessorTransformer = new AccessorTransformer(methodBody){
                private final /* synthetic */ MethodBody this$0;

                public InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) throws UnresolvableLabelException {
                    return this.this$0.resolveLabel(((LabelReference)instructionAccessor).getName());
                }
                {
                    this.this$0 = methodBody;
                    this.constructor$0(methodBody);
                }

                private final void constructor$0(MethodBody methodBody) {
                }
            };
            codeInfo.transformAccessors(accessorTransformer);
        }
        catch (UnresolvableLabelException unresolvableLabelException) {
            throw new KsmError(null, unresolvableLabelException.getFormattedMessage());
        }
        catch (BadAccessorException badAccessorException) {
            throw new KsmError(null, KsmMessages.UNEXPECTED_EXCEPTION, badAccessorException.getMessage());
        }
        int n = 0;
        while (n < instructionArray.length) {
            if (instructionArray[n] instanceof SwitchInstruction) {
                ((SwitchInstruction)instructionArray[n]).selectSwitchType();
            }
            ++n;
        }
        return codeInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

