/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBlockError;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CLoopContext;
import at.dms.kjc.CSimpleBodyContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JAssignmentExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLoopStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JWhileStatement
extends JLoopStatement {
    private JExpression cond;
    private JStatement body;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        try {
            CLoopContext cLoopContext = new CLoopContext(cBodyContext, this);
            this.cond = this.cond.analyse(new CExpressionContext(cLoopContext));
            cLoopContext.close(this.getTokenReference());
            this.check((CContext)cBodyContext, this.cond.getType() == CStdType.Boolean, KjcMessages.WHILE_COND_NOTBOOLEAN, this.cond.getType());
            if (!this.cond.isConstant()) {
                CSimpleBodyContext cSimpleBodyContext = cBodyContext.cloneContext();
                CLoopContext cLoopContext2 = new CLoopContext(cBodyContext, this);
                this.body.analyse(cLoopContext2);
                cLoopContext2.close(this.getTokenReference());
                cBodyContext.merge(cSimpleBodyContext);
            } else {
                this.check(cBodyContext, this.cond.booleanValue(), KjcMessages.STATEMENT_UNREACHABLE);
                if (this.cond instanceof JAssignmentExpression) {
                    cBodyContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.ASSIGNMENT_IN_CONDITION));
                }
                CLoopContext cLoopContext3 = new CLoopContext(cBodyContext, this);
                this.body.analyse(cLoopContext3);
                if (cLoopContext3.isBreakTarget()) {
                    cLoopContext3.adopt(cLoopContext3.getBreakContextSummary());
                }
                cLoopContext3.close(this.getTokenReference());
                cBodyContext.setReachable(cLoopContext3.isBreakTarget());
            }
        }
        catch (CBlockError cBlockError) {
            cBodyContext.reportTrouble(cBlockError);
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitWhileStatement(this, this.cond, this.body);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        codeSequence.pushContext(this);
        if (this.cond.isConstant() && this.cond.booleanValue()) {
            codeSequence.plantLabel(this.getContinueLabel());
            this.body.genCode(codeSequence);
            codeSequence.plantJumpInstruction(167, this.getContinueLabel());
        } else {
            CodeLabel codeLabel = new CodeLabel();
            codeSequence.plantJumpInstruction(167, this.getContinueLabel());
            codeSequence.plantLabel(codeLabel);
            this.body.genCode(codeSequence);
            codeSequence.plantLabel(this.getContinueLabel());
            this.cond.genBranch(true, codeSequence, codeLabel);
        }
        codeSequence.plantLabel(this.getBreakLabel());
        codeSequence.popContext(this);
    }

    public JWhileStatement(TokenReference tokenReference, JExpression jExpression, JStatement jStatement, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.cond = jExpression;
        this.body = jStatement;
    }
}

