/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.SwitchInstruction;
import at.dms.compiler.CWarning;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CSwitchBodyContext;
import at.dms.kjc.CSwitchGroupContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JStatement;
import at.dms.kjc.JSwitchGroup;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import java.util.Vector;

public class JSwitchStatement
extends JStatement {
    private JExpression expr;
    private JSwitchGroup[] groups;
    private boolean hasBreak;
    private CodeLabel endLabel = new CodeLabel();

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        this.expr = this.expr.analyse(new CExpressionContext(cBodyContext));
        this.check(cBodyContext, this.expr.getType().isAssignableTo(CStdType.Integer), KjcMessages.SWITCH_BADEXPR);
        CSwitchBodyContext cSwitchBodyContext = new CSwitchBodyContext(cBodyContext, this);
        CSwitchGroupContext[] cSwitchGroupContextArray = new CSwitchGroupContext[this.groups.length];
        int n = 0;
        while (n < this.groups.length) {
            cSwitchGroupContextArray[n] = n == 0 || !cSwitchGroupContextArray[n - 1].isReachable() ? new CSwitchGroupContext(cSwitchBodyContext) : cSwitchGroupContextArray[n - 1];
            this.groups[n].analyse(cSwitchGroupContextArray[n]);
            ++n;
        }
        n = cSwitchBodyContext.defaultExists() ? 1 : 0;
        int n2 = 0;
        while (n2 < cSwitchGroupContextArray.length) {
            if (n != 0 && (cSwitchGroupContextArray[n2].isReachable() || cSwitchGroupContextArray[n2].isBreaked())) {
                cSwitchBodyContext.adopt(cSwitchGroupContextArray[n2]);
                n = 0;
            } else if (cSwitchGroupContextArray[n2].isBreaked() || n2 == cSwitchGroupContextArray.length - 1 && cSwitchGroupContextArray[n2].isReachable()) {
                cSwitchBodyContext.merge(cSwitchGroupContextArray[n2]);
            }
            if (cSwitchGroupContextArray[n2].isReachable() && n2 != cSwitchGroupContextArray.length - 1) {
                cBodyContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.CASE_FALL_THROUGH));
            }
            ++n2;
        }
        cSwitchBodyContext.setReachable(cSwitchGroupContextArray.length == 0 || cSwitchGroupContextArray[cSwitchGroupContextArray.length - 1].isReachable() || this.hasBreak || !cSwitchBodyContext.defaultExists());
        cSwitchBodyContext.close(this.getTokenReference());
        if (!cSwitchBodyContext.defaultExists()) {
            cBodyContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.SWITCH_NO_DEFAULT));
        }
    }

    CType getType() {
        return this.expr.getType();
    }

    public void addBreak(CBodyContext cBodyContext) {
        this.hasBreak = true;
    }

    public CodeLabel getBreakLabel() {
        return this.endLabel;
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitSwitchStatement(this, this.expr, this.groups);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        CodeLabel codeLabel = new CodeLabel();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < this.groups.length) {
            this.groups[n].collectLabels(codeLabel, vector, vector2);
            ++n;
        }
        this.expr.genCode(codeSequence, false);
        codeSequence.pushContext(this);
        codeSequence.plantInstruction(new SwitchInstruction((InstructionAccessor)codeLabel, vector, vector2));
        n = 0;
        while (n < this.groups.length) {
            this.groups[n].genCode(codeSequence);
            ++n;
        }
        if (!codeLabel.hasAddress()) {
            codeSequence.plantLabel(codeLabel);
        }
        codeSequence.plantLabel(this.endLabel);
        codeSequence.popContext(this);
        this.endLabel = null;
    }

    public JSwitchStatement(TokenReference tokenReference, JExpression jExpression, JSwitchGroup[] jSwitchGroupArray, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.expr = jExpression;
        this.groups = jSwitchGroupArray;
        this.hasBreak = false;
    }
}

