/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CStdType;
import at.dms.kjc.CSwitchGroupContext;
import at.dms.kjc.CType;
import at.dms.kjc.JExpression;
import at.dms.kjc.JPhylum;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;
import at.dms.util.MessageDescription;

public class JSwitchLabel
extends JPhylum {
    private JExpression expr;

    public boolean isDefault() {
        return this.expr == null;
    }

    public Integer getLabel() {
        return new Integer(this.getLabelValue());
    }

    public void analyse(CSwitchGroupContext cSwitchGroupContext) throws PositionedError {
        if (this.expr != null) {
            this.expr = this.expr.analyse(new CExpressionContext(cSwitchGroupContext));
            this.check(cSwitchGroupContext, this.expr.isConstant(), KjcMessages.SWITCH_LABEL_EXPR_NOTCONST);
            this.check((CContext)cSwitchGroupContext, this.expr.isAssignableTo(cSwitchGroupContext.getType()), KjcMessages.SWITCH_LABEL_OVERFLOW, this.expr.getType());
            try {
                cSwitchGroupContext.addLabel(new Integer(this.getLabelValue()));
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
        }
        try {
            cSwitchGroupContext.addDefault();
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
    }

    protected void fail(CContext cContext, MessageDescription messageDescription, Object[] objectArray) throws PositionedError {
        throw new CLineError(this.getTokenReference(), messageDescription, objectArray);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitSwitchLabel(this, this.expr);
    }

    private int getLabelValue() {
        CType cType = this.expr.getType();
        if (cType == CStdType.Byte) {
            return this.expr.byteValue();
        }
        if (cType == CStdType.Char) {
            return this.expr.charValue();
        }
        if (cType == CStdType.Short) {
            return this.expr.shortValue();
        }
        if (cType == CStdType.Integer) {
            return this.expr.intValue();
        }
        throw new InconsistencyException("unexpected type " + cType);
    }

    public JSwitchLabel(TokenReference tokenReference, JExpression jExpression) {
        super(tokenReference);
        this.expr = jExpression;
    }
}

