/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CConstructorContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CField;
import at.dms.kjc.CSourceField;
import at.dms.kjc.CType;
import at.dms.kjc.CVariableInfo;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JThisExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JFieldAccessExpression
extends JExpression {
    private boolean constantPrefix;
    protected JExpression prefix;
    protected String ident;
    protected CField field;

    public String getIdent() {
        return this.ident;
    }

    public CType getType() {
        return this.field.getType();
    }

    public boolean isConstant() {
        return this.constantPrefix && this.field.isFinal() && this.field.getValue() != null && this.field.getValue().isConstant();
    }

    public boolean isLValue(CExpressionContext cExpressionContext) {
        if (!this.field.isFinal() || !(this.field instanceof CSourceField)) {
            return true;
        }
        if (cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared()) {
            return !CVariableInfo.mayBeInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition()));
        }
        return true;
    }

    public boolean isFinal() {
        return this.field.isFinal();
    }

    public boolean isInitialized(CExpressionContext cExpressionContext) {
        if (!(this.field instanceof CSourceField) || this.field.isStatic()) {
            return true;
        }
        if (cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared()) {
            return CVariableInfo.isInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition()));
        }
        return true;
    }

    public void setInitialized(CExpressionContext cExpressionContext) {
        if (this.field instanceof CSourceField && cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared()) {
            cExpressionContext.setFieldInfo(((CSourceField)this.field).getPosition(), 3);
        }
    }

    public CField getField() {
        return this.field;
    }

    public JLiteral getLiteral() {
        return (JLiteral)this.field.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JFieldAccessExpression[");
        stringBuffer.append(this.prefix);
        stringBuffer.append(", ");
        stringBuffer.append(this.ident);
        if (this.isConstant()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.field);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        CClass cClass = cExpressionContext.getClassContext().getCClass();
        this.findPrefix(cClass, cExpressionContext);
        this.checkAccess(cClass, cExpressionContext);
        this.check((CContext)cExpressionContext, this.field.isStatic() || !(this.prefix instanceof JTypeNameExpression), KjcMessages.FIELD_NOSTATIC, this.ident);
        if (this.field.isStatic() && !(this.prefix instanceof JTypeNameExpression)) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.INSTANCE_PREFIXES_STATIC_FIELD, this.ident, this.prefix.getType()));
        }
        if (this.field instanceof CSourceField && !cExpressionContext.discardValue()) {
            ((CSourceField)this.field).setUsed();
        }
        if (this.isConstant()) {
            return this.field.getValue();
        }
        return this;
    }

    protected void findPrefix(CClass cClass, CExpressionContext cExpressionContext) throws PositionedError {
        if (this.prefix != null) {
            this.prefix = this.prefix.analyse(cExpressionContext);
            this.check((CContext)cExpressionContext, this.prefix.getType().isClassType(), KjcMessages.FIELD_BADACCESS, this.prefix.getType());
            this.constantPrefix = this.prefix instanceof JTypeNameExpression;
        } else {
            this.constantPrefix = true;
            try {
                this.field = cExpressionContext.lookupField(cClass, this.ident);
                if (this.field == null) {
                    this.field = cExpressionContext.getClassContext().lookupOuterField(cClass, this.ident);
                }
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
            this.check((CContext)cExpressionContext, this.field != null, KjcMessages.FIELD_UNKNOWN, this.ident);
            if (!this.field.isStatic()) {
                this.check((CContext)cExpressionContext, !cClass.isStatic() || cClass.descendsFrom(this.field.getOwner()), KjcMessages.FIELD_STATICERR, this.ident);
                this.prefix = new JThisExpression(this.getTokenReference(), this.field.getOwner());
            } else {
                this.prefix = new JTypeNameExpression(this.getTokenReference(), this.field.getOwner().getType());
            }
            this.prefix = this.prefix.analyse(cExpressionContext);
        }
    }

    public void checkAccess(CClass cClass, CExpressionContext cExpressionContext) throws PositionedError {
        CClass cClass2 = this.prefix.getType().getCClass();
        try {
            this.field = cClass2.lookupField(cClass, this.ident);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check((CContext)cExpressionContext, this.field != null, KjcMessages.FIELD_UNKNOWN, this.ident);
        try {
            this.field.getType().checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (cExpressionContext.getMethodContext() instanceof CConstructorContext && this.prefix instanceof JThisExpression && !this.field.isStatic() && this.field.getType().isClassType() && this.field.getType().getCClass() == cExpressionContext.getClassContext().getCClass()) {
            this.check((CContext)cExpressionContext, ((CConstructorContext)cExpressionContext.getMethodContext()).isSuperConstructorCalled(), KjcMessages.CONSTRUCTOR_EXPLICIT_CALL, this.field.getIdent());
        }
    }

    public boolean equals(Object object) {
        return object instanceof JFieldAccessExpression && this.field.equals(((JFieldAccessExpression)object).field) && this.prefix.equals(((JFieldAccessExpression)object).prefix);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitFieldExpression(this, this.prefix, this.getIdent());
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        if (!this.field.isStatic()) {
            this.prefix.genCode(codeSequence, bl);
        } else if (this.prefix != null) {
            this.prefix.genCode(codeSequence, true);
        }
        if (!bl) {
            this.field.genLoad(codeSequence);
        }
    }

    public void genStartStoreCode(CodeSequence codeSequence) {
        if (!this.field.isStatic()) {
            this.prefix.genCode(codeSequence, false);
        } else if (this.prefix != null) {
            this.prefix.genCode(codeSequence, true);
        }
    }

    public void genEndStoreCode(CodeSequence codeSequence, boolean bl) {
        if (!bl) {
            int n = this.field.isStatic() ? (this.getType().getSize() == 2 ? 92 : 89) : (this.getType().getSize() == 2 ? 93 : 90);
            codeSequence.plantNoArgInstruction(n);
        }
        this.field.genStore(codeSequence);
    }

    public JFieldAccessExpression(TokenReference tokenReference, JExpression jExpression, String string) {
        super(tokenReference);
        this.prefix = jExpression;
        this.ident = string;
        this.constantPrefix = false;
    }

    public JFieldAccessExpression(TokenReference tokenReference, String string) {
        this(tokenReference, null, string);
    }
}

