/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBinaryExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JEqualityExpression
extends JBinaryExpression {
    protected final boolean equal;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JEqualityExpression[");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(this.equal ? " == " : " != ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        CType cType = this.left.getType();
        CType cType2 = this.right.getType();
        if (cType.isNumeric()) {
            this.check(cExpressionContext, cType2.isNumeric(), KjcMessages.EQUALITY_TYPE, cType, cType2);
            CType cType3 = CNumericType.binaryPromote(cType, cType2);
            this.left = this.left.convertType(cType3, cExpressionContext);
            this.right = this.right.convertType(cType3, cExpressionContext);
        } else if (cType == CStdType.Boolean) {
            this.check(cExpressionContext, cType2 == CStdType.Boolean, KjcMessages.EQUALITY_TYPE, cType, cType2);
            if (this.left instanceof JBooleanLiteral || this.right instanceof JBooleanLiteral) {
                cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.COMPARING_BOOLEAN_CONSTANT));
            }
        } else {
            this.check(cExpressionContext, cType.isReference() && cType2.isReference(), KjcMessages.EQUALITY_TYPE, cType, cType2);
            this.check(cExpressionContext, cType2.isCastableTo(cType) || cType.isCastableTo(cType2), KjcMessages.EQUALITY_TYPE, cType, cType2);
            if (this.left.getType().equals(CStdType.String) && this.right.getType().equals(CStdType.String) && (this.left.isConstant() || this.right.isConstant())) {
                cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.STRING_COMPARISON));
            }
        }
        this.type = CStdType.Boolean;
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding();
        }
        return this;
    }

    public JExpression constantFolding() {
        boolean bl;
        switch (this.left.getType().getTypeID()) {
            case 5: {
                bl = this.left.intValue() == this.right.intValue();
                break;
            }
            case 6: {
                bl = this.left.longValue() == this.right.longValue();
                break;
            }
            case 7: {
                bl = this.left.floatValue() == this.right.floatValue();
                break;
            }
            case 8: {
                bl = this.left.doubleValue() == this.right.doubleValue();
                break;
            }
            case 11: {
                bl = this.left.booleanValue() == this.right.booleanValue();
                break;
            }
            case 9: {
                if (this.left.getType() != CStdType.String) {
                    throw new InconsistencyException("unexpected type " + this.left.getType());
                }
                bl = this.left.stringValue().equals(this.right.stringValue());
                break;
            }
            default: {
                throw new InconsistencyException("unexpected type " + this.left.getType());
            }
        }
        return new JBooleanLiteral(this.getTokenReference(), this.equal ? bl : !bl);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitEqualityExpression(this, this.equal, this.left, this.right);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.genBooleanResultCode(codeSequence, bl);
    }

    protected void genBranch(JExpression jExpression, JExpression jExpression2, boolean bl, CodeSequence codeSequence, CodeLabel codeLabel) {
        this.setLineNumber(codeSequence);
        if (jExpression.getType() == CStdType.Null) {
            jExpression2.genCode(codeSequence, false);
            codeSequence.plantJumpInstruction(bl == this.equal ? 198 : 199, codeLabel);
        } else if (jExpression2.getType() == CStdType.Null) {
            jExpression.genCode(codeSequence, false);
            codeSequence.plantJumpInstruction(bl == this.equal ? 198 : 199, codeLabel);
        } else if (jExpression.isConstant() && (jExpression.getType() == CStdType.Integer || jExpression.getType() == CStdType.Boolean) && ((JLiteral)jExpression).isDefault()) {
            jExpression2.genCode(codeSequence, false);
            codeSequence.plantJumpInstruction(bl == this.equal ? 153 : 154, codeLabel);
        } else if (jExpression2.isConstant() && (jExpression2.getType() == CStdType.Integer || jExpression2.getType() == CStdType.Boolean) && ((JLiteral)jExpression2).isDefault()) {
            jExpression.genCode(codeSequence, false);
            codeSequence.plantJumpInstruction(bl == this.equal ? 153 : 154, codeLabel);
        } else {
            jExpression.genCode(codeSequence, false);
            jExpression2.genCode(codeSequence, false);
            switch (jExpression.getType().getTypeID()) {
                case 9: 
                case 10: {
                    codeSequence.plantJumpInstruction(bl == this.equal ? 165 : 166, codeLabel);
                    break;
                }
                case 7: {
                    codeSequence.plantNoArgInstruction(149);
                    codeSequence.plantJumpInstruction(bl == this.equal ? 153 : 154, codeLabel);
                    break;
                }
                case 6: {
                    codeSequence.plantNoArgInstruction(148);
                    codeSequence.plantJumpInstruction(bl == this.equal ? 153 : 154, codeLabel);
                    break;
                }
                case 8: {
                    codeSequence.plantNoArgInstruction(151);
                    codeSequence.plantJumpInstruction(bl == this.equal ? 153 : 154, codeLabel);
                    break;
                }
                default: {
                    codeSequence.plantJumpInstruction(bl == this.equal ? 159 : 160, codeLabel);
                }
            }
        }
    }

    public JEqualityExpression(TokenReference tokenReference, boolean bl, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.equal = bl;
    }
}

