/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JBooleanLiteral
extends JLiteral {
    private final boolean value;

    public CType getType() {
        return CStdType.Boolean;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public boolean isDefault() {
        return !this.value;
    }

    public JExpression convertType(CType cType, CExpressionContext cExpressionContext) {
        switch (cType.getTypeID()) {
            case 11: {
                return this;
            }
            case 9: {
                if (cType != CStdType.String) {
                    throw new InconsistencyException("cannot convert from boolean to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from boolean to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBooleanLiteral(this.value);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value ? 1 : 0));
        }
    }

    public void genBranch(boolean bl, CodeSequence codeSequence, CodeLabel codeLabel) {
        this.setLineNumber(codeSequence);
        if (this.value == bl) {
            codeSequence.plantJumpInstruction(167, codeLabel);
        }
    }

    public JBooleanLiteral(TokenReference tokenReference, boolean bl) {
        super(tokenReference);
        this.value = bl;
    }
}

