/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBlockContext;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JBlock
extends JStatement {
    protected final JStatement[] body;

    public boolean isEmpty() {
        return this.body.length == 0;
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        CBlockContext cBlockContext = new CBlockContext(cBodyContext);
        int n = 0;
        while (n < this.body.length) {
            if (!cBlockContext.isReachable()) {
                throw new CLineError(this.body[n].getTokenReference(), KjcMessages.STATEMENT_UNREACHABLE);
            }
            try {
                this.body[n].analyse(cBlockContext);
            }
            catch (CLineError cLineError) {
                cBlockContext.reportTrouble(cLineError);
            }
            ++n;
        }
        cBlockContext.close(this.getTokenReference());
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBlockStatement(this, this.body, this.getComments());
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        int n = 0;
        while (n < this.body.length) {
            this.body[n].genCode(codeSequence);
            ++n;
        }
    }

    public JBlock(TokenReference tokenReference, JStatement[] jStatementArray, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.body = jStatementArray;
    }
}

