/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JAddExpression
extends JBinaryArithmeticExpression {
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JAddExpression[");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        this.check(cExpressionContext, this.left.getType() != CStdType.Void && this.right.getType() != CStdType.Void, KjcMessages.ADD_BADTYPE, this.left.getType(), this.right.getType());
        this.check(cExpressionContext, !(this.left instanceof JTypeNameExpression) && !(this.right instanceof JTypeNameExpression), KjcMessages.ADD_BADTYPE, this.left.getType(), this.right.getType());
        try {
            this.type = JAddExpression.computeType(this.left.getType(), this.right.getType());
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (!this.type.equals(CStdType.String)) {
            this.left = this.left.convertType(this.type, cExpressionContext);
            this.right = this.right.convertType(this.type, cExpressionContext);
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            if (this.type.equals(CStdType.String)) {
                this.left = this.left.convertType(this.type, cExpressionContext);
                this.right = this.right.convertType(this.type, cExpressionContext);
                return new JStringLiteral(this.getTokenReference(), this.left.stringValue() + this.right.stringValue());
            }
            return this.constantFolding();
        }
        return this;
    }

    public static CType computeType(CType cType, CType cType2) throws UnpositionedError {
        if (cType.equals(CStdType.String)) {
            if (cType2 == CStdType.Void) {
                throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
            }
            return CStdType.String;
        }
        if (cType2.equals(CStdType.String)) {
            if (cType == CStdType.Void) {
                throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
            }
            return CStdType.String;
        }
        if (cType.isNumeric() && cType2.isNumeric()) {
            return CNumericType.binaryPromote(cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
    }

    public int compute(int n, int n2) {
        return n + n2;
    }

    public long compute(long l, long l2) {
        return l + l2;
    }

    public float compute(float f, float f2) {
        return f + f2;
    }

    public double compute(double d, double d2) {
        return d + d2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBinaryExpression(this, "+", this.left, this.right);
    }

    public static int getOpcode(CType cType) {
        switch (cType.getTypeID()) {
            case 7: {
                return 98;
            }
            case 6: {
                return 97;
            }
            case 8: {
                return 99;
            }
        }
        return 96;
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        if (this.type.equals(CStdType.String)) {
            codeSequence.plantClassRefInstruction(187, "java/lang/StringBuffer");
            codeSequence.plantNoArgInstruction(89);
            codeSequence.plantMethodRefInstruction(183, "java/lang/StringBuffer", "<init>", "()V");
            this.appendToStringBuffer(codeSequence, this.left);
            this.appendToStringBuffer(codeSequence, this.right);
            codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "toString", "()Ljava/lang/String;");
        } else {
            this.left.genCode(codeSequence, false);
            this.right.genCode(codeSequence, false);
            codeSequence.plantNoArgInstruction(JAddExpression.getOpcode(this.getType()));
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.getType());
        }
    }

    private void appendToStringBuffer(CodeSequence codeSequence, JExpression jExpression) {
        if (jExpression instanceof JAddExpression && jExpression.getType().equals(CStdType.String)) {
            ((JAddExpression)jExpression).appendToStringBuffer(codeSequence, ((JAddExpression)jExpression).left);
            ((JAddExpression)jExpression).appendToStringBuffer(codeSequence, ((JAddExpression)jExpression).right);
        } else {
            CType cType = jExpression.getType();
            jExpression.genCode(codeSequence, false);
            if (!cType.isReference() || cType.equals(CStdType.String)) {
                if (cType == CStdType.Byte || cType == CStdType.Short) {
                    cType = CStdType.Integer;
                }
                codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "append", "(" + cType.getSignature() + ")Ljava/lang/StringBuffer;");
            } else {
                codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
            }
        }
    }

    public JAddExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
    }
}

