/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClassType;
import at.dms.kjc.CContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.util.SimpleStringBuffer;
import at.dms.util.Utils;

public class CArrayType
extends CClassType {
    private CType baseType;
    private int arrayBound;

    public String toString() {
        String string = this.baseType.toString();
        int n = 0;
        while (n < this.arrayBound) {
            string = string + "[]";
            ++n;
        }
        return string;
    }

    public String getQualifiedName() {
        return this.getSignature();
    }

    public void appendSignature(SimpleStringBuffer simpleStringBuffer) {
        int n = 0;
        while (n < this.arrayBound) {
            simpleStringBuffer.append('[');
            ++n;
        }
        this.baseType.appendSignature(simpleStringBuffer);
    }

    public int getSize() {
        return 1;
    }

    public boolean isReference() {
        return true;
    }

    public boolean isArrayType() {
        return true;
    }

    public CType getBaseType() {
        Utils.assert(this.baseType != null);
        Utils.assert(!(this.baseType instanceof CArrayType));
        return this.baseType;
    }

    public CType getElementType() {
        Utils.assert(this.baseType != null);
        Utils.assert(!(this.baseType instanceof CArrayType));
        if (this.arrayBound == 1) {
            return this.baseType;
        }
        return new CArrayType(this.baseType, this.arrayBound - 1);
    }

    public int getArrayBound() {
        return this.arrayBound;
    }

    public boolean checked() {
        return this.baseType.checked();
    }

    public boolean equals(CType cType) {
        if (!cType.isArrayType()) {
            return false;
        }
        CArrayType cArrayType = (CArrayType)cType;
        return this.baseType.equals(cArrayType.baseType) && this.arrayBound == cArrayType.arrayBound;
    }

    public void checkType(CContext cContext) throws UnpositionedError {
        if (!this.isChecked()) {
            this.setClass(CStdType.Object.getCClass());
            this.baseType.checkType(cContext);
        }
    }

    public boolean isAssignableTo(CType cType) {
        if (cType.isArrayType()) {
            if (this.arrayBound == ((CArrayType)cType).arrayBound && this.baseType.isAssignableTo(((CArrayType)cType).baseType)) {
                return true;
            }
            if (this.arrayBound < ((CArrayType)cType).arrayBound) {
                return false;
            }
            return ((CArrayType)cType).baseType.equals(CStdType.Object);
        }
        return cType.equals(CStdType.Object);
    }

    public boolean isCastableTo(CType cType) {
        if (cType.isArrayType()) {
            CType cType2 = ((CArrayType)cType).baseType;
            int n = ((CArrayType)cType).arrayBound;
            if (this.arrayBound == n) {
                if (this.baseType.isPrimitive()) {
                    return this.baseType == cType2;
                }
                return this.baseType.isCastableTo(cType2);
            }
            if (this.arrayBound < n) {
                return this.baseType.isCastableTo(new CArrayType(cType2, n - this.arrayBound));
            }
            return new CArrayType(this.baseType, this.arrayBound - n).isCastableTo(cType2);
        }
        if (cType.isClassType()) {
            if (cType.equals(CStdType.Object)) {
                return true;
            }
            return cType.getCClass().getQualifiedName().equals("java/lang/Cloneable");
        }
        return false;
    }

    public CArrayType(CType cType, int n) {
        this.type = 10;
        Utils.assert(cType != null);
        Utils.assert(n > 0);
        if (cType.isArrayType()) {
            this.arrayBound = n + ((CArrayType)cType).arrayBound;
            this.baseType = ((CArrayType)cType).baseType;
        } else {
            this.arrayBound = n;
            this.baseType = cType;
        }
    }
}

