/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ClassConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import java.io.DataOutput;
import java.io.IOException;

public class MultiarrayInstruction
extends Instruction {
    private ClassConstant type;
    private int dims;

    public boolean canComplete() {
        return true;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.type);
    }

    int getSize() {
        return 4;
    }

    public String getType() {
        return this.type.getName();
    }

    public int getDimension() {
        return this.dims;
    }

    public int getPushedOnStack() {
        return 1;
    }

    public int getStack() {
        return 1 - this.dims;
    }

    public byte getReturnType() {
        return 6;
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        dataOutput.writeShort(this.type.getIndex());
        dataOutput.writeByte((byte)(this.dims & 0xFF));
    }

    public MultiarrayInstruction(String string, int n) {
        super(197);
        this.type = new ClassConstant(string);
        this.dims = n;
    }

    public MultiarrayInstruction(ClassConstant classConstant, int n) {
        super(197);
        this.type = classConstant;
        this.dims = n;
    }
}

