/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.ControlFlow;
import at.dms.backend.QNode;
import at.dms.backend.QTemporary;
import at.dms.util.Utils;
import java.util.Hashtable;
import java.util.Vector;

public class LivenessAnalysis {
    private Hashtable hash = new Hashtable();
    private Vector vect = new Vector();
    private QTemporary[] temps;
    private BasicBlock[] bblocks;
    private BasicBlock[] eblocks;
    private static /* synthetic */ Class class$Lat$dms$backend$QTemporary;

    public void run() {
        ControlFlow.setMarked(this.bblocks, false);
        this.analyse(this.bblocks[0]);
        int n = 0;
        while (n < this.eblocks.length) {
            this.analyse(this.eblocks[n]);
            ++n;
        }
        n = 1;
        while (n != 0) {
            ControlFlow.setMarked(this.bblocks, false);
            n = this.calculateLiveness(this.bblocks[0]) ? 1 : 0;
            int n2 = 0;
            while (n2 < this.eblocks.length) {
                n |= this.calculateLiveness(this.eblocks[n2]);
                ++n2;
            }
        }
    }

    public QTemporary[] getTemporaries() {
        return this.temps;
    }

    private void analyse(BasicBlock basicBlock) {
        if (basicBlock.isMarked()) {
            return;
        }
        basicBlock.setMarked(true);
        QNode[] qNodeArray = basicBlock.getQuadruples();
        int n = 0;
        while (n < qNodeArray.length) {
            this.analyseNode(basicBlock, n, qNodeArray[n]);
            ++n;
        }
        BasicBlock[] basicBlockArray = basicBlock.getSuccessors();
        QNode[][] qNodeArray2 = basicBlock.getSuccessorAccess();
        int n2 = qNodeArray.length;
        int n3 = 0;
        while (n3 < basicBlockArray.length) {
            int n4 = 0;
            while (qNodeArray2[n3] != null && n4 < qNodeArray2[n3].length) {
                this.analyseNode(basicBlock, n2++, qNodeArray2[n3][n4]);
                ++n4;
            }
            this.analyse(basicBlockArray[n3]);
            ++n3;
        }
        this.temps = (QTemporary[])Utils.toArray(this.vect, class$Lat$dms$backend$QTemporary != null ? class$Lat$dms$backend$QTemporary : (class$Lat$dms$backend$QTemporary = LivenessAnalysis.class$("at.dms.backend.QTemporary")));
    }

    private void analyseNode(BasicBlock basicBlock, int n, QNode qNode) {
        QTemporary qTemporary = qNode.getDef();
        QTemporary[] qTemporaryArray = qNode.getUses();
        if (qTemporary != null) {
            qTemporary.def(basicBlock, n);
            if (!this.hash.containsKey(qTemporary)) {
                this.hash.put(qTemporary, qTemporary);
                this.vect.addElement(qTemporary);
            }
        }
        if (qTemporaryArray != null) {
            int n2 = 0;
            while (n2 < qTemporaryArray.length) {
                qTemporaryArray[n2].use(basicBlock, n);
                if (!this.hash.containsKey(qTemporaryArray[n2])) {
                    this.hash.put(qTemporaryArray[n2], qTemporaryArray[n2]);
                    this.vect.addElement(qTemporaryArray[n2]);
                }
                ++n2;
            }
        }
    }

    private boolean calculateLiveness(BasicBlock basicBlock) {
        if (basicBlock.isMarked()) {
            return false;
        }
        basicBlock.setMarked(true);
        boolean bl = false;
        QNode[] qNodeArray = basicBlock.getQuadruples();
        int n = qNodeArray.length - 1;
        while (n >= 0) {
            bl |= this.calculateLiveness(basicBlock, n, -1, qNodeArray[n]);
            --n;
        }
        BasicBlock[] basicBlockArray = basicBlock.getSuccessors();
        QNode[][] qNodeArray2 = basicBlock.getSuccessorAccess();
        int n2 = qNodeArray.length;
        int n3 = 0;
        while (n3 < basicBlockArray.length) {
            int n4 = 0;
            while (qNodeArray2[n3] != null && n4 < qNodeArray2[n3].length) {
                bl |= this.calculateLiveness(basicBlock, n3, n4, qNodeArray2[n3][n4]);
                ++n4;
            }
            bl |= this.calculateLiveness(basicBlockArray[n3]);
            ++n3;
        }
        return bl;
    }

    private boolean calculateLiveness(BasicBlock basicBlock, int n, int n2, QNode qNode) {
        QTemporary qTemporary = qNode.getDef();
        QTemporary[] qTemporaryArray = qNode.getUses();
        Object[] objectArray = qNode.getLivein();
        Object[] objectArray2 = qNode.getLiveout();
        qNode.setLivein(this.livein(qTemporaryArray, (QTemporary[])objectArray2, qTemporary));
        boolean bl = !LivenessAnalysis.equals(qNode.getLivein(), objectArray);
        qNode.setLiveout(this.liveout(basicBlock, n, n2));
        boolean bl2 = !LivenessAnalysis.equals(objectArray2, qNode.getLiveout());
        objectArray2 = qNode.getLiveout();
        objectArray = qNode.getLivein();
        return bl |= bl2;
    }

    private static final boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != objectArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private QTemporary[] liveout(BasicBlock basicBlock, int n, int n2) {
        QNode[] qNodeArray = basicBlock.getSuccessorNodes(n, n2);
        if (qNodeArray.length == 1) {
            return qNodeArray[0].getLivein();
        }
        Vector<QTemporary> vector = new Vector<QTemporary>();
        int n3 = 0;
        while (n3 < qNodeArray.length) {
            QTemporary[] qTemporaryArray = qNodeArray[n3].getLivein();
            int n4 = 0;
            while (n4 < qTemporaryArray.length) {
                if (!vector.contains(qTemporaryArray[n4])) {
                    vector.addElement(qTemporaryArray[n4]);
                }
                ++n4;
            }
            ++n3;
        }
        return (QTemporary[])Utils.toArray(vector, class$Lat$dms$backend$QTemporary != null ? class$Lat$dms$backend$QTemporary : (class$Lat$dms$backend$QTemporary = LivenessAnalysis.class$("at.dms.backend.QTemporary")));
    }

    private QTemporary[] livein(QTemporary[] qTemporaryArray, QTemporary[] qTemporaryArray2, QTemporary qTemporary) {
        int n;
        int n2 = qTemporaryArray.length;
        int n3 = 0;
        while (n3 < qTemporaryArray2.length) {
            block10: {
                if (qTemporaryArray2[n3] != qTemporary) {
                    n = 0;
                    while (n < qTemporaryArray.length) {
                        if (qTemporaryArray2[n3] != qTemporaryArray[n]) {
                            ++n;
                            continue;
                        }
                        break block10;
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 == qTemporaryArray.length) {
            return qTemporaryArray;
        }
        QTemporary[] qTemporaryArray3 = new QTemporary[n2];
        n2 = qTemporaryArray.length;
        n = 0;
        while (n < qTemporaryArray.length) {
            qTemporaryArray3[n] = qTemporaryArray[n];
            ++n;
        }
        n = 0;
        while (n < qTemporaryArray2.length) {
            block11: {
                if (qTemporaryArray2[n] != qTemporary) {
                    int n4 = 0;
                    while (n4 < qTemporaryArray.length) {
                        if (qTemporaryArray2[n] != qTemporaryArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block11;
                    }
                    qTemporaryArray3[n2++] = qTemporaryArray2[n];
                }
            }
            ++n;
        }
        return qTemporaryArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LivenessAnalysis(BasicBlock[] basicBlockArray, BasicBlock[] basicBlockArray2) {
        this.bblocks = basicBlockArray;
        this.eblocks = basicBlockArray2;
    }
}

