/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc;
    private int count;
    private OutputStream strm;

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void finish() throws IOException {
        super.finish();
        if (this.count > -1) {
            this.writeInt((int)this.crc.getValue());
            this.writeInt(this.count);
            this.count = -1;
        }
    }

    private void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.strm.write(byArray);
    }

    private void writeByte(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.strm.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
        this.count += n2;
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 512);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream, new Deflater(-1, true), n);
        this.strm = outputStream;
        this.crc = new CRC32();
        this.count = 0;
        this.writeByte(31);
        this.writeByte(139);
        this.writeByte(8);
        this.writeByte(0);
        this.writeInt(0);
        this.writeByte(2);
        this.writeByte(255);
    }
}

