/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DriverManager {
    private static Vector drivers = new Vector();
    private static int timeout = 0;
    private static PrintStream strm = null;

    public static synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        return DriverManager.getConnection(string, properties);
    }

    public static synchronized Connection getConnection(String string) throws SQLException {
        return DriverManager.getConnection(string, new Properties());
    }

    public static synchronized Connection getConnection(String string, Properties properties) throws SQLException {
        Enumeration enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Connection connection;
            Driver driver = (Driver)enumeration.nextElement();
            if (!driver.acceptsURL(string) || (connection = driver.connect(string, properties)) == null) continue;
            return connection;
        }
        throw new SQLException("driver not found: " + string);
    }

    public static Driver getDriver(String string) throws SQLException {
        Enumeration enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = (Driver)enumeration.nextElement();
            if (!driver.acceptsURL(string)) continue;
            return driver;
        }
        throw new SQLException("driver not found: " + string);
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        drivers.addElement(driver);
    }

    public static void deregisterDriver(Driver driver) throws SQLException {
        drivers.removeElement(driver);
    }

    public static Enumeration getDrivers() {
        return drivers.elements();
    }

    public static void setLoginTimeout(int n) {
        timeout = n;
    }

    public static int getLoginTimeout() {
        return timeout;
    }

    public static void setLogStream(PrintStream printStream) {
        strm = printStream;
    }

    public static PrintStream getLogStream() {
        return strm;
    }

    public static void println(String string) {
        if (strm != null) {
            strm.println(string);
        }
    }

    private DriverManager() {
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("jdbc.drivers", ""), ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

