/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.StringTokenizer;
import kaffe.net.DefaultURLStreamHandlerFactory;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -7627629688361524110L;
    private static final String HANDLER_PROP = "java.protocol.handler.pkgs";
    private static URLStreamHandlerFactory defaultFactory = new DefaultURLStreamHandlerFactory();
    private static URLStreamHandlerFactory factory;
    private static final HashMap defaultHandlers;
    private URLStreamHandler handler;
    private String protocol;
    private String host = "";
    private int port = -1;
    private String file = "";
    private String ref;
    private URLConnection conn;

    private void setHandler(String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (uRLStreamHandler != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.handler = uRLStreamHandler;
            return;
        }
        uRLStreamHandler = (URLStreamHandler)defaultHandlers.get(string);
        if (uRLStreamHandler != null) {
            this.handler = uRLStreamHandler;
            return;
        }
        if (factory != null && (uRLStreamHandler = factory.createURLStreamHandler(string)) != null) {
            defaultHandlers.put(string, uRLStreamHandler);
            this.handler = uRLStreamHandler;
            return;
        }
        String string2 = System.getProperties().getProperty(HANDLER_PROP);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    uRLStreamHandler = (URLStreamHandler)Class.forName(stringTokenizer.nextToken() + "." + string + ".Handler").newInstance();
                    defaultHandlers.put(string, uRLStreamHandler);
                    this.handler = uRLStreamHandler;
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if ((uRLStreamHandler = defaultFactory.createURLStreamHandler(string)) != null) {
            defaultHandlers.put(string, uRLStreamHandler);
            this.handler = uRLStreamHandler;
            return;
        }
        throw new MalformedURLException("unknown protocol: " + string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        if (this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file)) {
            boolean bl = this.ref == null ? uRL.ref == null : this.ref.equals(uRL.ref);
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public int hashCode() {
        return this.protocol.hashCode() ^ this.host.hashCode() ^ this.file.hashCode();
    }

    public URLConnection openConnection() throws IOException {
        this.conn = this.handler.openConnection(this);
        this.conn.connect();
        return this.conn;
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public boolean sameFile(URL uRL) {
        return this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file);
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.ref = string4;
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSetFactory();
            }
        } else {
            throw new Error("factory already set");
        }
        factory = uRLStreamHandlerFactory;
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public String toString() {
        return this.toExternalForm();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setHandler(this.protocol, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3, null);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this(string, string2, n, string3, null);
    }

    public URL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (string == null || string2 == null && !string.equals("file") || string3 == null) {
            throw new NullPointerException();
        }
        if (string.equals("file") && string2 != null && string2.length() != 0) {
            this.setHandler("ftp", uRLStreamHandler);
        } else {
            this.setHandler(string, uRLStreamHandler);
        }
        this.handler.setURL(this, string, string2, n, string3, "");
    }

    public URL(String string) throws MalformedURLException {
        this(null, string);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(uRL, string, null);
    }

    public URL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        int n3 = string.lastIndexOf(35);
        if (n != -1 && (n2 == -1 || n < n2)) {
            this.protocol = string.substring(0, n);
            if (uRL != null && uRL.protocol.equals(this.protocol)) {
                this.host = uRL.host;
                this.port = uRL.port;
                this.file = uRL.file;
            }
        } else {
            if (uRL == null) {
                throw new MalformedURLException("no protocol: " + string);
            }
            this.protocol = uRL.protocol;
            this.host = uRL.host;
            this.port = uRL.port;
            this.file = uRL.file;
        }
        if (n3 != -1 && n3 + 1 < string.length()) {
            this.ref = string.substring(n3 + 1);
        }
        this.setHandler(this.protocol, uRLStreamHandler);
        try {
            this.handler.parseURL(this, string, n + 1, n3 != -1 ? n3 : string.length());
        }
        catch (Error error) {
            throw new MalformedURLException(error.getMessage());
        }
    }

    static {
        defaultHandlers = new HashMap();
    }

    class DefaultSerialization {
        private String file;
        private int hashCode;
        private String host;
        private int port;
        private String protocol;
        private String ref;

        private void readDefaultObject() {
            URL.this.set(this.protocol, this.host, this.port, this.file, this.ref);
        }

        private void writeDefaultObject() {
            this.file = URL.this.file;
            this.hashCode = URL.this.hashCode();
            this.host = URL.this.host;
            this.port = URL.this.port;
            this.protocol = URL.this.protocol;
            this.ref = URL.this.ref;
        }

        DefaultSerialization() {
        }
    }
}

