/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MouseEvt;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

class PopupWindow
extends Window {
    static int xOffs = 8;
    static boolean skipRelease;
    MenuItem selection;
    Vector items;
    Component client;
    PopupWindow sub;

    public void dispose() {
        this.disposeSubMenus();
        super.dispose();
        if (this == MouseEvt.getGrab()) {
            MouseEvt.releaseMouse(this.client);
        }
    }

    void disposeAll() {
        Component component = AWTEvent.keyTgt;
        PopupWindow popupWindow = this.rootWnd();
        popupWindow.dispose();
        if (component instanceof PopupWindow) {
            popupWindow.client.requestFocus();
        }
    }

    void disposeSubMenus() {
        PopupWindow popupWindow = this.sub;
        while (popupWindow != null) {
            popupWindow.dispose();
            popupWindow = popupWindow.sub;
        }
        this.sub = null;
    }

    int getY(MenuItem menuItem) {
        int n = this.items.size();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            MenuItem menuItem2 = (MenuItem)this.items.elementAt(n3);
            if (menuItem2 == menuItem) {
                return n2;
            }
            n2 += menuItem2.getHeight();
            ++n3;
        }
        return -1;
    }

    boolean isMaster(Component component) {
        PopupWindow popupWindow = this;
        while (popupWindow.client instanceof PopupWindow) {
            if (popupWindow.client == component) {
                return true;
            }
            popupWindow = (PopupWindow)popupWindow.client;
        }
        return false;
    }

    MenuItem itemAt(int n) {
        int n2 = this.items.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n4);
            if ((n3 += menuItem.getHeight()) > n) {
                return menuItem;
            }
            ++n4;
        }
        return null;
    }

    boolean openSubMenu() {
        if (this.sub != null) {
            return false;
        }
        if (this.selection == null || !(this.selection instanceof Menu)) {
            return false;
        }
        Vector vector = ((Menu)this.selection).items;
        if (vector == null || vector.size() == 0) {
            return false;
        }
        this.sub = new PopupWindow(this, this.owner, vector);
        this.sub.popupAt(this.x + this.width, this.y + this.getY(this.selection));
        return true;
    }

    public void paint(Graphics graphics) {
        int n = this.items.size();
        int n2 = 1;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        graphics.setColor(this.bgClr);
        graphics.fill3DRect(1, 1, this.width - 2, this.height - 2, true);
        int n3 = 0;
        while (n3 < n) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n3);
            n2 += this.paintItem(menuItem, graphics, n2);
            ++n3;
        }
    }

    int paintItem(MenuItem menuItem, Graphics graphics, int n) {
        int n2 = menuItem.paint(graphics, 1, xOffs, n, this.width - 3, 0, this.bgClr, this.fgClr, menuItem == this.selection);
        if (menuItem instanceof Menu) {
            int n3 = n + n2 / 2;
            int n4 = this.width - 5;
            int n5 = 0;
            while (n5 < 4) {
                graphics.drawLine(n4 - 2 * n5, n3 - n5, n4 - 2 * n5, n3 + n5);
                ++n5;
            }
        }
        return n2;
    }

    public void popupAt(int n, int n2) {
        Dimension dimension = Toolkit.singleton.getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        if (n + dimension2.width > dimension.width) {
            n = dimension.width - dimension2.width;
        }
        if (n2 + dimension2.height > dimension.height) {
            n2 = dimension.height - dimension2.height;
        }
        this.setBounds(n, n2, dimension2.width, dimension2.height);
        this.setVisible(true);
        if (!(this.client instanceof PopupWindow)) {
            skipRelease = true;
            this.requestFocus();
        }
        if (MouseEvt.buttonPressed) {
            MouseEvt.grabMouse(this);
        }
    }

    public Dimension preferredSize() {
        int n = this.items != null ? this.items.size() : 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        while (n5 < n) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n5);
            if (menuItem instanceof Menu) {
                n4 = 3;
            }
            n3 = Math.max(n3, menuItem.getWidth());
            n2 += menuItem.getHeight();
            ++n5;
        }
        return new Dimension(n3 + n4 * xOffs + 4, n2 + 4);
    }

    void process(FocusEvent focusEvent) {
        if (focusEvent.id == FocusEvent.FOCUS_GAINED) {
            this.disposeSubMenus();
        } else if (AWTEvent.keyTgt != this.sub && !this.isMaster(AWTEvent.keyTgt)) {
            this.disposeAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void process(KeyEvent keyEvent) {
        switch (keyEvent.id) {
            case 401: {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        this.processSelection();
                        keyEvent.consumed = true;
                        break;
                    }
                    case 38: {
                        if (!this.selectPrev()) break;
                        keyEvent.consumed = true;
                        break;
                    }
                    case 40: {
                        if (!this.selectNext()) break;
                        keyEvent.consumed = true;
                        break;
                    }
                    case 27: {
                        this.disposeAll();
                        keyEvent.consumed = true;
                        break;
                    }
                    case 37: {
                        if (!this.selectUpper()) break;
                        keyEvent.consumed = true;
                        break;
                    }
                    case 39: {
                        if (!this.selectLower()) break;
                        keyEvent.consumed = true;
                        break;
                    }
                }
                break;
            }
        }
        super.process(keyEvent);
    }

    void processMotion(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (mouseEvent.id) {
            case 503: {
                MenuItem menuItem = this.itemAt(n2);
                if (this.sub != null && menuItem != this.selection) {
                    this.requestFocus();
                }
                this.selectItem(menuItem);
                break;
            }
            case 506: {
                PopupWindow popupWindow;
                skipRelease = false;
                if (this.contains(n, n2)) {
                    this.selectItem(this.itemAt(n2));
                    if (this.selection == null || !(this.selection instanceof Menu)) break;
                    this.openSubMenu();
                    break;
                }
                if (!(this.client instanceof PopupWindow) || !(popupWindow = (PopupWindow)this.client).contains(n -= popupWindow.x - this.x, n2 -= popupWindow.y - this.y) || popupWindow.itemAt(n2) == popupWindow.selection) break;
                popupWindow.disposeSubMenus();
                break;
            }
        }
    }

    void processMouse(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        super.processMouse(mouseEvent);
        switch (mouseEvent.id) {
            case 501: {
                this.selectItem(this.itemAt(n2));
                break;
            }
            case 502: {
                if (MouseEvt.getGrab() == this) {
                    MouseEvt.releaseMouse(null);
                }
                if (skipRelease) {
                    skipRelease = false;
                    break;
                }
                if (this.contains(n, n2) && this.selection != null) {
                    this.processSelection();
                    break;
                }
                this.disposeAll();
                break;
            }
            case 504: {
                this.requestFocus();
                break;
            }
        }
    }

    void processSelection() {
        if (this.selection == null) {
            return;
        }
        if (this.selection instanceof Menu) {
            this.selectLower();
        } else {
            this.disposeAll();
            this.selection.handleShortcut(null);
        }
    }

    PopupWindow rootWnd() {
        Component component = this;
        while (component != null) {
            if (!(component instanceof PopupWindow)) continue;
            PopupWindow popupWindow = component;
            if (!(popupWindow.client instanceof PopupWindow)) {
                return popupWindow;
            }
            component = popupWindow.client;
        }
        return null;
    }

    boolean selectItem(MenuItem menuItem) {
        if (menuItem == null || menuItem.isSeparator() || menuItem == this.selection) {
            return false;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            if (this.selection != null) {
                MenuItem menuItem2 = this.selection;
                this.selection = null;
                this.paintItem(menuItem2, graphics, this.getY(menuItem2));
            }
            this.selection = menuItem;
            this.paintItem(this.selection, graphics, this.getY(this.selection));
            graphics.dispose();
        }
        return true;
    }

    boolean selectLower() {
        if (this.sub == null) {
            if (this.selection instanceof Menu) {
                this.disposeSubMenus();
                this.openSubMenu();
            } else {
                return false;
            }
        }
        this.sub.requestFocus();
        Vector vector = this.sub.items;
        if (vector != null && vector.size() > 0) {
            this.sub.selectItem((MenuItem)vector.firstElement());
            return true;
        }
        return false;
    }

    boolean selectNext() {
        int n = this.items != null ? this.items.size() : 0;
        int n2 = 0;
        if (n == 0) {
            return false;
        }
        if (this.selection != null) {
            n2 = this.items.indexOf(this.selection) + 1;
        }
        int n3 = n2;
        while (n3 < n) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n3);
            if (!menuItem.isSeparator()) {
                this.selectItem(menuItem);
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean selectPrev() {
        int n = this.items != null ? this.items.size() : 0;
        int n2 = n - 1;
        if (n == 0) {
            return false;
        }
        if (this.selection != null) {
            n2 = this.items.indexOf(this.selection) - 1;
        }
        int n3 = n2;
        while (n3 >= 0) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n3);
            if (!menuItem.isSeparator()) {
                this.selectItem(menuItem);
                return true;
            }
            --n3;
        }
        return false;
    }

    boolean selectUpper() {
        if (!(this.client instanceof PopupWindow)) {
            return false;
        }
        PopupWindow popupWindow = (PopupWindow)this.client;
        popupWindow.requestFocus();
        return true;
    }

    public PopupWindow(Component component, Frame frame, Vector vector) {
        super(frame);
        this.client = component;
        this.items = vector;
    }
}

