/*
 * Decompiled with CFR 0.152.
 */
package at.dms.optimize;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.Constants;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.SwitchInstruction;
import at.dms.optimize.Optimizer;
import at.dms.util.InconsistencyException;
import java.util.Enumeration;
import java.util.Vector;

public class InstructionHandle
extends AbstractInstructionAccessor
implements Constants {
    private Instruction insn;
    private boolean reached;
    private InstructionHandle prev;
    private InstructionHandle next;
    private Vector lineNumbers;
    private Vector accessors;

    public void attachTo(AccessorContainer accessorContainer) {
        if (accessorContainer instanceof LineNumberInfo) {
            if (this.lineNumbers == null) {
                this.lineNumbers = new Vector();
            }
            this.lineNumbers.addElement(new Integer(((LineNumberInfo)accessorContainer).getLine()));
        }
    }

    public void addLineNumberInfo(Vector vector) {
        if (this.lineNumbers != null) {
            Enumeration enumeration = this.lineNumbers.elements();
            while (enumeration.hasMoreElements()) {
                int n = (Integer)enumeration.nextElement();
                vector.addElement(new LineNumberInfo((short)n, this));
            }
        }
    }

    public Instruction getInstruction() {
        return this.insn;
    }

    public InstructionHandle getNext() {
        return this.next;
    }

    public InstructionHandle getPrevious() {
        return this.prev;
    }

    public boolean isJump() {
        return this.insn instanceof JumpInstruction;
    }

    public JumpInstruction getJump() {
        return (JumpInstruction)this.insn;
    }

    public LocalVarInstruction getLocal() {
        return (LocalVarInstruction)this.insn;
    }

    public InstructionHandle getTarget() {
        return (InstructionHandle)((JumpInstruction)this.insn).getTarget();
    }

    public void setTarget(InstructionHandle instructionHandle) {
        ((JumpInstruction)this.insn).setTarget(instructionHandle);
    }

    public int getOpcode() {
        return this.insn.getOpcode();
    }

    public void setNext(InstructionHandle instructionHandle) {
        this.next = instructionHandle;
        if (instructionHandle != null) {
            instructionHandle.prev = this;
        }
    }

    public boolean isReached() {
        return this.reached;
    }

    public boolean isTarget() {
        return this.accessors != null;
    }

    public void set() {
        this.reached = this.prev == null || this.accessors != null || this.prev.isReached() && this.prev.getInstruction().canComplete();
    }

    public void destroy() {
        if (this.accessors != null && this.getNext() == null) {
            this.insn = new NoArgInstruction(0);
        } else {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            int n = 0;
            while (this.accessors != null && n < this.accessors.size()) {
                this.changeTarget((AccessorContainer)this.accessors.elementAt(n), this.next);
                ++n;
            }
            this.notifyTargetOnRemove();
        }
    }

    public boolean remove() {
        if (this.accessors != null && this.getNext() == null) {
            return false;
        }
        this.destroy();
        return true;
    }

    public void reset() {
        if (this.insn instanceof AccessorContainer) {
            if (this.insn instanceof JumpInstruction) {
                ((InstructionHandle)((JumpInstruction)this.insn).getTarget()).addAccessor((JumpInstruction)this.insn);
            } else if (this.insn instanceof SwitchInstruction) {
                SwitchInstruction switchInstruction = (SwitchInstruction)this.insn;
                int n = -1;
                while (n < switchInstruction.getSwitchCount()) {
                    ((InstructionHandle)switchInstruction.getTarget(n)).addAccessor(switchInstruction);
                    ++n;
                }
            } else {
                throw new InconsistencyException(">>>>>>>" + this.insn);
            }
        }
    }

    public void clean() {
        this.reached = false;
        this.accessors = null;
    }

    public void replaceBy(Instruction instruction) {
        this.notifyTargetOnRemove();
        this.insn = instruction;
        this.notifyTargetOnAdd();
        this.set();
    }

    public void replaceBy(Instruction[] instructionArray) {
        this.replaceBy(instructionArray[0]);
        InstructionHandle instructionHandle = this;
        InstructionHandle instructionHandle2 = this.next;
        int n = 1;
        while (n < instructionArray.length) {
            instructionHandle = new InstructionHandle(instructionArray[n], instructionHandle);
            instructionHandle.notifyTargetOnAdd();
            ++n;
        }
        instructionHandle.next = instructionHandle2;
        if (instructionHandle.next != null) {
            instructionHandle.next.prev = instructionHandle;
        }
    }

    public void addAccessor(AccessorContainer accessorContainer) {
        if (this.accessors == null) {
            this.accessors = new Vector();
        }
        this.accessors.addElement(accessorContainer);
    }

    public AccessorContainer getAccessor(int n) {
        return (AccessorContainer)this.accessors.elementAt(n);
    }

    public void removeAccessor(AccessorContainer accessorContainer) {
        this.accessors.removeElement(accessorContainer);
        if (this.accessors.size() == 0) {
            this.accessors = null;
        }
    }

    public void removeAccessors() {
        this.accessors = null;
    }

    private void notifyTargetOnRemove() {
        if (this.insn instanceof JumpInstruction) {
            ((InstructionHandle)((JumpInstruction)this.insn).getTarget()).removeAccessor((AccessorContainer)((Object)this.insn));
        } else if (this.insn instanceof SwitchInstruction) {
            SwitchInstruction switchInstruction = (SwitchInstruction)this.insn;
            int n = -1;
            while (n < switchInstruction.getSwitchCount()) {
                ((InstructionHandle)switchInstruction.getTarget(n)).removeAccessor((AccessorContainer)((Object)this.insn));
                ++n;
            }
        }
    }

    private void notifyTargetOnAdd() {
        if (this.insn instanceof JumpInstruction) {
            ((InstructionHandle)((JumpInstruction)this.insn).getTarget()).addAccessor((AccessorContainer)((Object)this.insn));
        } else if (this.insn instanceof SwitchInstruction) {
            SwitchInstruction switchInstruction = (SwitchInstruction)this.insn;
            int n = -1;
            while (n < switchInstruction.getSwitchCount()) {
                ((InstructionHandle)switchInstruction.getTarget(n)).addAccessor((AccessorContainer)((Object)this.insn));
                ++n;
            }
        }
    }

    private void changeTarget(AccessorContainer accessorContainer, InstructionHandle instructionHandle) {
        if (accessorContainer instanceof JumpInstruction) {
            ((JumpInstruction)accessorContainer).setTarget(instructionHandle);
            instructionHandle.addAccessor(accessorContainer);
        } else if (accessorContainer instanceof SwitchInstruction) {
            SwitchInstruction switchInstruction = (SwitchInstruction)accessorContainer;
            int n = -1;
            while (n < switchInstruction.getSwitchCount()) {
                if (switchInstruction.getTarget(n) == this) {
                    switchInstruction.setTarget(n, instructionHandle);
                }
                ++n;
            }
            instructionHandle.addAccessor(accessorContainer);
        } else if (accessorContainer instanceof HandlerInfo) {
            HandlerInfo handlerInfo = (HandlerInfo)accessorContainer;
            if (handlerInfo.getStart() == this) {
                handlerInfo.setStart(instructionHandle);
            }
            if (handlerInfo.getEnd() == this) {
                handlerInfo.setEnd(instructionHandle);
            }
            if (handlerInfo.getHandler() == this) {
                handlerInfo.setHandler(instructionHandle);
            }
        } else if (accessorContainer instanceof Optimizer) {
            ((Optimizer)accessorContainer).setCodeStart(instructionHandle);
        } else {
            throw new InconsistencyException("" + accessorContainer);
        }
    }

    public InstructionHandle(Instruction instruction, InstructionHandle instructionHandle) {
        this.insn = instruction;
        this.prev = instructionHandle;
        this.next = null;
        if (instructionHandle != null) {
            instructionHandle.setNext(this);
        }
    }
}

