/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassPath;
import at.dms.compiler.CWarning;
import at.dms.compiler.Compiler;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.compiler.WarningFilter;
import at.dms.compiler.tools.antlr.extra.InputBuffer;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.kjc.BytecodeOptimizer;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CStdType;
import at.dms.kjc.CTopLevel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.DefaultFilter;
import at.dms.kjc.JCompilationUnit;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcOptions;
import at.dms.kjc.KjcParser;
import at.dms.kjc.KjcPrettyPrinter;
import at.dms.kjc.ThreadedChecker;
import at.dms.kjc.ThreadedGenerator;
import at.dms.kjc.ThreadedParser;
import at.dms.kjc.ThreadedVisitor;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Main
extends Compiler {
    protected Vector infiles = new Vector();
    protected boolean errorFound;
    protected KjcOptions options;
    private WarningFilter filter = new DefaultFilter();
    private Vector classes = new Vector(100);
    private static /* synthetic */ Class class$Lat$dms$kjc$CSourceClass;

    public static void main(String[] stringArray) {
        boolean bl = Main.compile(stringArray);
        System.exit(bl ? 0 : 1);
    }

    public static boolean compile(String[] stringArray) {
        return new Main().run(stringArray);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        this.initialize();
        if (this.infiles.size() == 0) {
            this.options.usage();
            this.inform(CompilerMessages.NO_INPUT_FILE);
            return false;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.COMPILATION_STARTED, new Integer(this.infiles.size()));
        }
        try {
            this.infiles = this.verifyFiles(this.infiles);
        }
        catch (UnpositionedError unpositionedError) {
            this.reportTrouble(unpositionedError);
            return false;
        }
        this.options.destination = this.checkDestination(this.options.destination);
        JCompilationUnit[] jCompilationUnitArray = new JCompilationUnit[this.infiles.size()];
        if (this.options.proc > jCompilationUnitArray.length) {
            this.options.proc = jCompilationUnitArray.length;
        }
        if (this.options.multi) {
            this.parseMultiProc(jCompilationUnitArray);
        } else {
            int n = 0;
            while (n < jCompilationUnitArray.length) {
                jCompilationUnitArray[n] = this.parseFile((File)this.infiles.elementAt(n));
                ++n;
            }
        }
        this.infiles = null;
        if (this.errorFound) {
            return false;
        }
        if (!this.options.beautify) {
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < jCompilationUnitArray.length) {
                this.checkInterface(jCompilationUnitArray[n]);
                ++n;
            }
            if (this.verboseMode()) {
                this.inform(CompilerMessages.INTERFACES_CHECKED, new Long(System.currentTimeMillis() - l));
            }
            if (this.errorFound) {
                return false;
            }
            n = 0;
            while (n < jCompilationUnitArray.length) {
                this.checkInitializers(jCompilationUnitArray[n]);
                ++n;
            }
            if (this.errorFound) {
                return false;
            }
            if (this.options.multi) {
                this.checkBodyMultiProc(jCompilationUnitArray);
            } else {
                n = 0;
                while (n < jCompilationUnitArray.length) {
                    this.checkBody(jCompilationUnitArray[n]);
                    if (!this.options.java && !this.options.beautify) {
                        jCompilationUnitArray[n] = null;
                    }
                    ++n;
                }
            }
            if (this.errorFound) {
                return false;
            }
        }
        if (!this.options.nowrite) {
            if (this.options.java || this.options.beautify) {
                if (this.options.multi) {
                    this.acceptMultiProc(jCompilationUnitArray);
                } else {
                    int n = 0;
                    while (n < jCompilationUnitArray.length) {
                        jCompilationUnitArray[n].accept(this, this.options.destination);
                        jCompilationUnitArray[n] = null;
                        ++n;
                    }
                }
            } else {
                this.genCode();
            }
        }
        if (this.errorFound) {
            return false;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.COMPILATION_ENDED);
        }
        CodeSequence.endSession();
        return true;
    }

    public boolean parseArguments(String[] stringArray) {
        this.options = new KjcOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        this.infiles = Utils.toVector(this.options.nonOptions);
        return true;
    }

    public void genCode() {
        CSourceClass[] cSourceClassArray = this.getClasses();
        BytecodeOptimizer bytecodeOptimizer = new BytecodeOptimizer(this.options.optimize);
        this.classes.setSize(0);
        try {
            if (this.options.multi) {
                this.genCodeMultiProc(cSourceClassArray, bytecodeOptimizer, this.options.destination);
            } else {
                int n = 0;
                while (n < cSourceClassArray.length) {
                    long l = System.currentTimeMillis();
                    cSourceClassArray[n].genCode(bytecodeOptimizer, this.options.destination);
                    if (this.verboseMode() && !cSourceClassArray[n].isNested()) {
                        this.inform(CompilerMessages.CLASSFILE_GENERATED, cSourceClassArray[n].getQualifiedName().replace('/', '.'), new Long(System.currentTimeMillis() - l));
                    }
                    cSourceClassArray[n] = null;
                    ++n;
                }
            }
        }
        catch (ClassFileFormatException classFileFormatException) {
            classFileFormatException.printStackTrace();
            this.reportTrouble(new UnpositionedError(CompilerMessages.FORMATTED_ERROR, classFileFormatException.getMessage()));
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, "classfile", iOException.getMessage()));
        }
    }

    protected void initialize() {
        ClassPath.init(this.options.classpath);
        CTopLevel.initSession(this);
        CStdType.init(this);
    }

    public boolean verboseMode() {
        return this.options.verbose;
    }

    public KjcPrettyPrinter getPrettyPrinter(String string) {
        return new KjcPrettyPrinter(string);
    }

    protected JCompilationUnit parseFile(File file) {
        JCompilationUnit jCompilationUnit;
        InputBuffer inputBuffer;
        try {
            inputBuffer = new InputBuffer(file, this.options.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.UNSUPPORTED_ENCODING, this.options.encoding));
            return null;
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, file.getPath(), iOException.getMessage()));
            return null;
        }
        long l = System.currentTimeMillis();
        KjcParser kjcParser = new KjcParser(this, inputBuffer);
        try {
            jCompilationUnit = kjcParser.jCompilationUnit();
        }
        catch (ParserException parserException) {
            this.reportTrouble(kjcParser.beautifyParseError(parserException));
            jCompilationUnit = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorFound = true;
            jCompilationUnit = null;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.FILE_PARSED, file.getPath(), new Long(System.currentTimeMillis() - l));
        }
        try {
            inputBuffer.close();
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, file.getPath(), iOException.getMessage()));
        }
        return jCompilationUnit;
    }

    protected void checkInterface(JCompilationUnit jCompilationUnit) {
        try {
            jCompilationUnit.checkInterface(this);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
    }

    protected void checkInitializers(JCompilationUnit jCompilationUnit) {
        try {
            jCompilationUnit.checkInitializers(this, this.classes);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
    }

    protected void checkBody(JCompilationUnit jCompilationUnit) {
        long l = System.currentTimeMillis();
        try {
            jCompilationUnit.checkBody(this, this.classes);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.BODY_CHECKED, jCompilationUnit.getFileName(), new Long(System.currentTimeMillis() - l));
        }
    }

    protected void generateJavaCode(JCompilationUnit jCompilationUnit) {
        long l = System.currentTimeMillis();
        jCompilationUnit.accept(this, this.options.destination);
        if (this.verboseMode()) {
            this.inform(CompilerMessages.JAVA_CODE_GENERATED, jCompilationUnit.getFileName(), new Long(System.currentTimeMillis() - l));
        }
    }

    protected void parseMultiProc(JCompilationUnit[] jCompilationUnitArray) {
        try {
            Thread[] threadArray = new Thread[this.options.proc];
            int n = jCompilationUnitArray.length / this.options.proc;
            int n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2] = new ThreadedParser(this, this.infiles, jCompilationUnitArray, n2 * n, n2 == this.options.proc - 1 ? jCompilationUnitArray.length : (n2 + 1) * n);
                threadArray[n2].start();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2].join();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void checkBodyMultiProc(JCompilationUnit[] jCompilationUnitArray) {
        try {
            Thread[] threadArray = new Thread[jCompilationUnitArray.length];
            int n = jCompilationUnitArray.length / this.options.proc;
            int n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2] = new ThreadedChecker(this, jCompilationUnitArray, n2 * n, n2 == this.options.proc - 1 ? jCompilationUnitArray.length : (n2 + 1) * n);
                threadArray[n2].start();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2].join();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void acceptMultiProc(JCompilationUnit[] jCompilationUnitArray) {
        try {
            Thread[] threadArray = new Thread[jCompilationUnitArray.length];
            int n = jCompilationUnitArray.length / this.options.proc;
            int n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2] = new ThreadedVisitor(this.options.destination, jCompilationUnitArray, n2 * n, n2 == this.options.proc - 1 ? jCompilationUnitArray.length : (n2 + 1) * n, this);
                threadArray[n2].start();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2].join();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void genCodeMultiProc(CSourceClass[] cSourceClassArray, BytecodeOptimizer bytecodeOptimizer, String string) {
        try {
            Thread[] threadArray = new Thread[cSourceClassArray.length];
            int n = cSourceClassArray.length / this.options.proc;
            int n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2] = new ThreadedGenerator(cSourceClassArray, bytecodeOptimizer, string, n2 * n, n2 == this.options.proc - 1 ? cSourceClassArray.length : (n2 + 1) * n);
                threadArray[n2].start();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.options.proc) {
                threadArray[n2].join();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void reportTrouble(PositionedError positionedError) {
        if (positionedError instanceof CWarning) {
            if (this.options.warning != 0 && this.filterWarning((CWarning)positionedError)) {
                this.inform(positionedError);
            }
        } else if (positionedError.getTokenReference() != TokenReference.NO_REF) {
            this.inform(positionedError);
            this.errorFound = true;
        }
    }

    public void reportTrouble(UnpositionedError unpositionedError) {
        this.inform(unpositionedError);
        this.errorFound = true;
    }

    protected boolean filterWarning(CWarning cWarning) {
        WarningFilter warningFilter = this.getFilter();
        int n = warningFilter.filter(cWarning);
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return cWarning.getSeverityLevel() <= this.options.warning;
            }
        }
        throw new InconsistencyException();
    }

    protected WarningFilter getFilter() {
        if (this.filter == null) {
            if (this.options.filter != null) {
                try {
                    this.filter = (WarningFilter)Class.forName(this.options.filter).newInstance();
                }
                catch (Exception exception) {
                    this.inform(KjcMessages.FILTER_NOT_FOUND, this.options.filter);
                }
            }
            if (this.filter == null) {
                this.filter = new DefaultFilter();
            }
        }
        return this.filter;
    }

    public boolean parseComments() {
        return this.options.deprecation || this.options.beautify && !this.options.nowrite;
    }

    public CSourceClass[] getClasses() {
        return (CSourceClass[])Utils.toArray(this.classes, class$Lat$dms$kjc$CSourceClass != null ? class$Lat$dms$kjc$CSourceClass : (class$Lat$dms$kjc$CSourceClass = Main.class$("at.dms.kjc.CSourceClass")));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

