/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.kjc.Constants;
import at.dms.util.InconsistencyException;

public class CModifier
implements Constants {
    private static final String[] NAMES = new String[]{"public", "private", "protected", "static", "final", "synchronized", "volatile", "transient", "native", null, "abstract", "strictfp"};
    private static final int[] CODES = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};

    public static String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < CODES.length) {
            if (NAMES[n2] != null && (n & CODES[n2]) != 0) {
                stringBuffer.append(NAMES[n2]);
                stringBuffer.append(" ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean contains(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean isSubsetOf(int n, int n2) {
        return (n & n2) == n;
    }

    public static int getSubsetOf(int n, int n2) {
        return n & n2;
    }

    public static int notElementsOf(int n, int n2) {
        return n & ~n2;
    }

    public static int getSubsetSize(int n, int n2) {
        n &= n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 32) {
            if ((1 << n4 & n) != 0) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static boolean checkOrder(int n, int n2) {
        return CModifier.getMaxPosition(n) < CModifier.getPosition(n2);
    }

    private static int getMaxPosition(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 32) {
            if ((1 << n3 & n) != 0) {
                n2 = Math.max(n2, CModifier.getPosition(1 << n3));
            }
            ++n3;
        }
        return n2;
    }

    private static int getPosition(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 1024: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 32: {
                return 7;
            }
            case 128: {
                return 8;
            }
            case 64: {
                return 9;
            }
            case 256: {
                return 10;
            }
            case 512: {
                return 11;
            }
            case 2048: {
                return 12;
            }
        }
        throw new InconsistencyException();
    }

    public static String getName(int n) {
        switch (n) {
            case 1: {
                return "public";
            }
            case 2: {
                return "private";
            }
            case 4: {
                return "protected";
            }
            case 8: {
                return "static";
            }
            case 16: {
                return "final";
            }
            case 32: {
                return "synchronized";
            }
            case 64: {
                return "volatile";
            }
            case 128: {
                return "transient";
            }
            case 256: {
                return "native";
            }
            case 512: {
                return "interface";
            }
            case 1024: {
                return "abstract";
            }
            case 2048: {
                return "strictfp";
            }
        }
        throw new InconsistencyException();
    }
}

