/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.InvokeinterfaceInstruction;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CMember;
import at.dms.kjc.CModifier;
import at.dms.kjc.CThrowableInfo;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.KjcMessages;
import at.dms.util.InconsistencyException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CMethod
extends CMember {
    private CType returnType;
    private CType[] parameters;
    private CClassType[] exceptions;

    public CMethod getMethod() {
        return this;
    }

    public final CType getReturnType() {
        return this.returnType;
    }

    public final CType[] getParameters() {
        return this.parameters;
    }

    public String getSignature() {
        return CType.genMethodSignature(this.returnType, this.parameters);
    }

    public CClassType[] getThrowables() {
        return this.exceptions;
    }

    public void setThrowables(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            int n = 0;
            this.exceptions = new CClassType[hashtable.size()];
            while (enumeration.hasMoreElements()) {
                this.exceptions[n++] = ((CThrowableInfo)((Object)enumeration)).getThrowable();
            }
        }
    }

    public boolean isNative() {
        return CModifier.contains(this.getModifiers(), 256);
    }

    public boolean isAbstract() {
        return CModifier.contains(this.getModifiers(), 1024);
    }

    public boolean isConstructor() {
        return this.getIdent() == "<init>";
    }

    public boolean equals(CMethod cMethod) {
        if (!this.getOwner().equals(cMethod.getOwner())) {
            return false;
        }
        if (this.getIdent() != cMethod.getIdent()) {
            return false;
        }
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameters.length) {
            if (!this.parameters[n].equals(cMethod.parameters[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isApplicableTo(String string, CType[] cTypeArray) {
        if (string != this.getIdent()) {
            return false;
        }
        if (cTypeArray.length != this.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < cTypeArray.length) {
            if (!cTypeArray[n].isAssignableTo(this.parameters[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isMoreSpecificThan(CMethod cMethod) {
        if (!this.getOwner().getType().isAssignableTo(cMethod.getOwner().getType())) {
            return false;
        }
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < cMethod.parameters.length) {
            if (!this.parameters[n].isAssignableTo(cMethod.parameters[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasSameSignature(CMethod cMethod) {
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameters.length) {
            if (!this.parameters[n].equals(cMethod.parameters[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void checkOverriding(CMethod cMethod) throws UnpositionedError {
        boolean bl;
        if (cMethod.isFinal()) {
            throw new UnpositionedError(KjcMessages.METHOD_OVERRIDE_FINAL, this);
        }
        if (!this.isStatic() && cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_INSTANCE_OVERRIDES_STATIC, this, cMethod.getOwner());
        }
        if (this.isStatic() && !cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_STATIC_HIDES_INSTANCE, this, cMethod.getOwner());
        }
        if (!this.returnType.equals(cMethod.getReturnType())) {
            throw new UnpositionedError(KjcMessages.METHOD_RETURN_DIFFERENT, this);
        }
        if (cMethod.isPublic()) {
            bl = !this.isPublic();
        } else if (cMethod.isProtected()) {
            bl = !(this.isProtected() || this.isPublic());
        } else if (!cMethod.isPrivate()) {
            bl = this.isPrivate();
        } else {
            throw new InconsistencyException("bad access: " + cMethod.getModifiers());
        }
        if (bl) {
            throw new UnpositionedError(KjcMessages.METHOD_ACCESS_DIFFERENT, this, cMethod.getOwner());
        }
        CClassType[] cClassTypeArray = cMethod.getThrowables();
        int n = 0;
        while (n < this.exceptions.length) {
            block15: {
                if (this.exceptions[n].isCheckedException()) {
                    int n2 = 0;
                    while (n2 < cClassTypeArray.length) {
                        if (!this.exceptions[n].isAssignableTo(cClassTypeArray[n2])) {
                            ++n2;
                            continue;
                        }
                        break block15;
                    }
                    throw new UnpositionedError(KjcMessages.METHOD_THROWS_DIFFERENT, this, this.exceptions[n]);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.returnType);
        stringBuffer.append(" ");
        stringBuffer.append(this.getOwner());
        stringBuffer.append(".");
        stringBuffer.append(this.getIdent());
        stringBuffer.append("(");
        int n = 0;
        while (n < this.parameters.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.parameters[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        if (this.getOwner().isInterface()) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.parameters.length) {
                n += this.parameters[n2].getSize();
                ++n2;
            }
            codeSequence.plantInstruction(new InvokeinterfaceInstruction(this.getPrefixName(), this.getIdent(), this.getSignature(), n + 1));
        } else {
            int n = this.isStatic() ? 184 : (bl || this.isPrivate() ? 183 : 182);
            codeSequence.plantMethodRefInstruction(n, this.getPrefixName(), this.getIdent(), this.getSignature());
        }
    }

    public CMethod(CClass cClass, int n, String string, CType cType, CType[] cTypeArray, CClassType[] cClassTypeArray, boolean bl) {
        super(cClass, n, string, bl);
        this.returnType = cType;
        this.parameters = cTypeArray;
        this.exceptions = cClassTypeArray;
    }
}

