/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ClassConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.NameAndTypeConstant;
import at.dms.classfile.PooledConstant;
import at.dms.util.Utils;
import java.io.DataOutput;
import java.io.IOException;

public abstract class ReferenceConstant
extends PooledConstant {
    private byte tag;
    private ClassConstant clazz;
    private NameAndTypeConstant nametype;

    Object getLiteral() {
        return null;
    }

    public String getName() {
        return this.clazz.getName() + "/" + this.nametype.getName();
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public String getTypeName() {
        return this.nametype.getName();
    }

    public void setTypeName(String string) {
        this.nametype.setName(string);
    }

    public String getType() {
        return this.nametype.getType();
    }

    public final int hashCode() {
        return ((this.clazz.hashCode() + this.nametype.hashCode()) * this.tag & 0xFFFFFFF0) + 8;
    }

    public final boolean equals(Object object) {
        return object instanceof ReferenceConstant && ((ReferenceConstant)object).clazz.equals(this.clazz) && ((ReferenceConstant)object).nametype.equals(this.nametype);
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.clazz);
        constantPool.addItem(this.nametype);
    }

    final void resolveConstants(PooledConstant pooledConstant) {
        this.setIndex(pooledConstant.getIndex());
        this.clazz.setIndex(((ReferenceConstant)pooledConstant).clazz.getIndex());
        this.nametype.setIndex(((ReferenceConstant)pooledConstant).nametype.getIndex());
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.tag);
        dataOutput.writeShort(this.clazz.getIndex());
        dataOutput.writeShort(this.nametype.getIndex());
    }

    public ReferenceConstant(byte by, String string, String string2) {
        String[] stringArray = Utils.splitQualifiedName(string);
        this.tag = by;
        this.clazz = new ClassConstant(stringArray[0]);
        this.nametype = new NameAndTypeConstant(stringArray[1], string2);
    }

    public ReferenceConstant(byte by, String string, String string2, String string3) {
        this.tag = by;
        this.clazz = new ClassConstant(string);
        this.nametype = new NameAndTypeConstant(string2, string3);
    }

    public ReferenceConstant(byte by, ClassConstant classConstant, NameAndTypeConstant nameAndTypeConstant) {
        this.tag = by;
        this.clazz = classConstant;
        this.nametype = nameAndTypeConstant;
    }
}

