/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InterfaceConstant;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class InvokeinterfaceInstruction
extends Instruction {
    private InterfaceConstant method;
    private int nargs;

    public boolean canComplete() {
        return true;
    }

    int getSize() {
        return 5;
    }

    public InterfaceConstant getInterfaceConstant() {
        return this.method;
    }

    public int getNbArgs() {
        return this.nargs;
    }

    public byte getReturnType() {
        String string = this.method.getType();
        switch (string.charAt(string.indexOf(")") + 1)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 4;
            }
            case 'F': {
                return 3;
            }
            case 'L': 
            case '[': {
                return 6;
            }
            case 'D': {
                return 2;
            }
            case 'J': {
                return 5;
            }
        }
        throw new InconsistencyException("invalid signature " + string);
    }

    public int getPushedOnStack() {
        String string = this.method.getType();
        switch (string.charAt(string.indexOf(")") + 1)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        throw new InconsistencyException("invalid signature x" + string);
    }

    public int getStack() {
        String string = this.method.getType();
        int n = 0;
        if (string.charAt(0) != '(') {
            throw new InconsistencyException("invalid signature " + string);
        }
        int n2 = 1;
        block12: while (true) {
            switch (string.charAt(n2++)) {
                case ')': {
                    break block12;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    ++n2;
                    --n;
                    break;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    ++n2;
                    --n;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    --n;
                    break;
                }
                case 'D': 
                case 'J': {
                    n -= 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid signature " + string);
                }
            }
        }
        switch (string.charAt(n2)) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                ++n;
                break;
            }
            case 'D': 
            case 'J': {
                n += 2;
                break;
            }
            default: {
                throw new InconsistencyException("invalid signature " + string);
            }
        }
        return n - 1;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.method);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        dataOutput.writeShort(this.method.getIndex());
        dataOutput.writeByte((byte)(this.nargs & 0xFF));
        dataOutput.writeByte(0);
    }

    public InvokeinterfaceInstruction(String string, String string2, int n) {
        super(185);
        this.method = new InterfaceConstant(string, string2);
        this.nargs = n;
    }

    public InvokeinterfaceInstruction(String string, String string2, String string3, int n) {
        super(185);
        this.method = new InterfaceConstant(string, string2, string3);
        this.nargs = n;
    }

    public InvokeinterfaceInstruction(InterfaceConstant interfaceConstant, int n) {
        super(185);
        this.method = interfaceConstant;
        this.nargs = n;
    }
}

