/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.AttributeList;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.ConstantValueAttribute;
import at.dms.classfile.DeprecatedAttribute;
import at.dms.classfile.Member;
import at.dms.classfile.SyntheticAttribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FieldInfo
extends Member {
    private static final int MODIFIER_MASK = 223;
    private AsciiConstant name;
    private AsciiConstant type;
    private AttributeList attributes;

    public String getName() {
        return this.name.getValue();
    }

    public void setName(String string) {
        this.name = new AsciiConstant(string);
    }

    public String getSignature() {
        return this.type.getValue();
    }

    public void getSignature(String string) {
        this.type = new AsciiConstant(string);
    }

    public Object getConstantValue() {
        Attribute attribute = this.attributes.get(2);
        return attribute == null ? null : ((ConstantValueAttribute)attribute).getLiteral();
    }

    public void setConstantValue(Object object) {
        if (object != null) {
            this.attributes.add(new ConstantValueAttribute(object));
        } else {
            this.attributes.remove(2);
        }
    }

    public boolean isDeprecated() {
        return this.attributes.get(11) != null;
    }

    public void setDeprecated(boolean bl) {
        if (bl) {
            this.attributes.add(new DeprecatedAttribute());
        } else {
            this.attributes.remove(11);
        }
    }

    public boolean isSynthetic() {
        return this.attributes.get(22) != null;
    }

    public void setSynthetic(boolean bl) {
        if (bl) {
            this.attributes.add(new SyntheticAttribute());
        } else {
            this.attributes.remove(22);
        }
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(this.name);
        constantPool.addItem(this.type);
        this.attributes.resolveConstants(constantPool);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException, ClassFileFormatException {
        dataOutput.writeShort(this.getModifiers() & 0xDF);
        dataOutput.writeShort(this.name.getIndex());
        dataOutput.writeShort(this.type.getIndex());
        this.attributes.write(constantPool, dataOutput);
    }

    public FieldInfo(short s, String string, String string2, Object object, boolean bl, boolean bl2) {
        super(s);
        this.name = new AsciiConstant(string);
        this.type = new AsciiConstant(string2);
        this.attributes = new AttributeList(object != null ? new ConstantValueAttribute(object) : null, bl ? new DeprecatedAttribute() : null, bl2 ? new SyntheticAttribute() : null);
    }

    public FieldInfo(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        this.setModifiers((short)dataInput.readUnsignedShort());
        this.name = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.type = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.attributes = new AttributeList(dataInput, constantPool, false);
    }
}

