/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BackendOptions;
import at.dms.backend.ControlFlow;
import at.dms.backend.HandleCreator;
import at.dms.backend.InstructionHandle;
import at.dms.backend.MethodEnv;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.MethodInfo;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Vector;

public class Optimizer
implements AccessorContainer {
    private InstructionHandle codeStart;
    private HandlerInfo[] handlers;
    private LocalVariableInfo[] localVariables;
    private static /* synthetic */ Class class$Lat$dms$classfile$LineNumberInfo;

    public static CodeInfo optimize(MethodInfo methodInfo, CodeInfo codeInfo, BackendOptions backendOptions) {
        Optimizer optimizer = new Optimizer(codeInfo);
        optimizer.buildBasicBlocks(optimizer.codeStart);
        MethodEnv methodEnv = new MethodEnv(methodInfo);
        ControlFlow controlFlow = new ControlFlow(methodEnv, optimizer.getCodeStart(), optimizer.handlers);
        if (backendOptions.verbose) {
            controlFlow.trace();
        }
        controlFlow.optimize();
        optimizer.setCodeStart(controlFlow.getInstructions());
        optimizer.cleanCode(optimizer.codeStart);
        return at.dms.optimize.Optimizer.optimize(optimizer.getCodeInfo(), backendOptions.optimize);
    }

    public static CodeInfo optimize(CodeInfo codeInfo) {
        return Optimizer.optimize(null, codeInfo, new BackendOptions());
    }

    public CodeInfo getCodeInfo() {
        CodeInfo codeInfo = new CodeInfo(this.buildInstructionArray(), this.handlers, this.buildLineNumberInfo(), this.localVariables);
        try {
            Optimizer optimizer = this;
            if (optimizer == null) {
                throw null;
            }
            AccessorTransformer accessorTransformer = new AccessorTransformer(optimizer){
                private final /* synthetic */ Optimizer this$0;

                public InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                    return ((InstructionHandle)instructionAccessor).getInstruction();
                }
                {
                    this.this$0 = optimizer;
                    this.constructor$0(optimizer);
                }

                private final void constructor$0(Optimizer optimizer) {
                }
            };
            codeInfo.transformAccessors(accessorTransformer);
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        return codeInfo;
    }

    private void buildBasicBlocks(InstructionHandle instructionHandle) {
        InstructionHandle instructionHandle2 = this.codeStart;
        while (instructionHandle2 != null) {
            instructionHandle2.reset();
            instructionHandle2 = instructionHandle2.getNext();
        }
        int n = 0;
        while (n < this.handlers.length) {
            ((InstructionHandle)this.handlers[n].getHandler()).addAccessor(this.handlers[n]);
            ((InstructionHandle)this.handlers[n].getStart()).addAccessor(this.handlers[n]);
            ((InstructionHandle)this.handlers[n].getEnd()).addAccessor(this.handlers[n]);
            ++n;
        }
    }

    private void cleanCode(InstructionHandle instructionHandle) {
        InstructionHandle instructionHandle2 = instructionHandle;
        if (instructionHandle2.isJump()) {
            this.setCodeStart(instructionHandle2.getTarget());
            instructionHandle2 = this.getCodeStart();
        }
        instructionHandle.clean();
        InstructionHandle instructionHandle3 = instructionHandle2.getNext();
        while (instructionHandle3 != null) {
            instructionHandle2.setNext(instructionHandle3);
            instructionHandle2 = instructionHandle3;
            instructionHandle3.clean();
            instructionHandle3 = instructionHandle3.getNext();
        }
        if (instructionHandle2 == instructionHandle) {
            instructionHandle2.setNext(null);
        }
        this.setCodeStart(instructionHandle);
    }

    private InstructionHandle installInstructionHandles(CodeInfo codeInfo) {
        Instruction[] instructionArray = codeInfo.getInstructions();
        InstructionHandle[] instructionHandleArray = new InstructionHandle[instructionArray.length];
        int n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandleArray[n] = new InstructionHandle(instructionArray[n], n == 0 ? null : instructionHandleArray[n - 1]);
            ++n;
        }
        try {
            codeInfo.transformAccessors(new HandleCreator(instructionArray, instructionHandleArray));
        }
        catch (BadAccessorException badAccessorException) {
            this.dumpCode(instructionArray);
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        return instructionHandleArray[0];
    }

    private void dumpCode(Instruction[] instructionArray) {
        int n = 0;
        while (n < instructionArray.length) {
            instructionArray[n].dump();
            ++n;
        }
        System.err.flush();
    }

    private Instruction[] buildInstructionArray() {
        int n = 0;
        Instruction[] instructionArray = this.codeStart;
        while (instructionArray != null) {
            ++n;
            instructionArray = instructionArray.getNext();
        }
        instructionArray = new Instruction[n];
        n = 0;
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            instructionArray[n] = instructionHandle.getInstruction();
            ++n;
            instructionHandle = instructionHandle.getNext();
        }
        return instructionArray;
    }

    private LineNumberInfo[] buildLineNumberInfo() {
        Vector vector = new Vector();
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            instructionHandle.addLineNumberInfo(vector);
            instructionHandle = instructionHandle.getNext();
        }
        return (LineNumberInfo[])Utils.toArray(vector, class$Lat$dms$classfile$LineNumberInfo != null ? class$Lat$dms$classfile$LineNumberInfo : (class$Lat$dms$classfile$LineNumberInfo = Optimizer.class$("at.dms.classfile.LineNumberInfo")));
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.codeStart = (InstructionHandle)this.codeStart.transform(accessorTransformer, this);
    }

    public void setCodeStart(InstructionHandle instructionHandle) {
        this.codeStart = instructionHandle;
        this.codeStart.addAccessor(this);
    }

    public InstructionHandle getCodeStart() {
        return this.codeStart;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Optimizer(CodeInfo codeInfo) {
        this.setCodeStart(this.installInstructionHandles(codeInfo));
        this.handlers = codeInfo.getHandlers();
        this.localVariables = codeInfo.getLocalVariables();
    }
}

