/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util.log;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import kaffe.util.DoubleLinkedObject;
import kaffe.util.log.LogClient;
import kaffe.util.log.LogStream;

public class SimpleLogViewer
extends Frame
implements LogClient {
    int lineHeight;
    FontMetrics fm;
    LogStream logStream;
    boolean isEnabled;
    PrintStream orgOut = System.out;

    public void disable() {
        this.isEnabled = false;
    }

    public void enable() {
        this.setVisible(true);
        this.isEnabled = true;
    }

    public static void main(String[] stringArray) {
        SimpleLogViewer simpleLogViewer = new SimpleLogViewer();
        LogStream logStream = new LogStream(30, simpleLogViewer);
        simpleLogViewer.enable();
        System.setOut(new PrintStream(logStream));
        System.setErr(System.out);
    }

    public void newLogLine(LogStream logStream) {
        if (!this.isEnabled) {
            return;
        }
        this.logStream = logStream;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        DoubleLinkedObject doubleLinkedObject = null;
        int n = insets.left + 2;
        int n2 = dimension.height - insets.bottom;
        int n3 = dimension.width - (insets.left + insets.right);
        int n4 = this.fm.getAscent();
        if (this.logStream != null) {
            doubleLinkedObject = this.logStream.getLastLine();
            n2 -= this.fm.getDescent();
            do {
                graphics.clearRect(insets.left, n2 - this.fm.getAscent(), n3, this.lineHeight);
                graphics.drawString(doubleLinkedObject.data.toString(), n, n2);
                doubleLinkedObject = doubleLinkedObject.prev;
            } while ((n2 -= this.lineHeight) > insets.top && doubleLinkedObject != null);
        }
        if (doubleLinkedObject == null) {
            graphics.clearRect(insets.left, insets.top, n3, n2 - insets.top);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        switch (windowEvent.getID()) {
            case 201: {
                this.isEnabled = false;
                this.dispose();
                break;
            }
            case 203: {
                this.isEnabled = false;
                break;
            }
            case 204: {
                this.isEnabled = true;
                break;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public SimpleLogViewer() {
        super("Log");
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setBounds(0, dimension.height / 2, 2 * dimension.width / 3, dimension.height / 2);
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        Font font = new Font("Monospaced", 0, 10);
        this.fm = this.getToolkit().getFontMetrics(font);
        this.setFont(font);
        this.lineHeight = this.fm.getHeight();
    }
}

