/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Timestamp
extends Date {
    private static final long serialVersionUID = 2745179027874758501L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DecimalFormat nanosFormat = new DecimalFormat("000000000");
    private int nanos;

    public static Timestamp valueOf(String string) throws IllegalArgumentException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = dateFormat.parse(string, parsePosition);
        if (date == null) {
            throw new IllegalArgumentException(string);
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        int n = parsePosition.getIndex() + 1;
        if (n < string.length() && string.charAt(n) == '.') {
            parsePosition.setIndex(n);
            Number number = nanosFormat.parse(string, parsePosition);
            if (number == null) {
                throw new IllegalArgumentException(string);
            }
            timestamp.setNanos(number.intValue());
        }
        return timestamp;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        dateFormat.format(this, stringBuffer, new FieldPosition(0));
        if (this.getNanos() != 0) {
            stringBuffer.append('.');
            nanosFormat.format(this.getNanos(), stringBuffer, new FieldPosition(0));
        }
        return stringBuffer.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        this.nanos = n;
    }

    public boolean equals(Timestamp timestamp) {
        return super.equals(timestamp) && this.nanos == timestamp.nanos;
    }

    public boolean before(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 < (l = timestamp.getTime())) {
            return true;
        }
        if (l2 > l) {
            return false;
        }
        return this.nanos < timestamp.nanos;
    }

    public boolean after(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 > (l = timestamp.getTime())) {
            return true;
        }
        if (l2 < l) {
            return false;
        }
        return this.nanos > timestamp.nanos;
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6);
        this.nanos = n7;
    }

    public Timestamp(long l) {
        super(l);
    }
}

