/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest digest;
    private boolean on;

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.on) {
            this.digest.update((byte)n);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.on) {
            this.digest.update(byArray, n, n2);
        }
    }

    public void on(boolean bl) {
        this.on = bl;
    }

    public String toString() {
        return "DigestOutputStream(" + this.out.toString() + ", " + this.digest.toString() + ")";
    }

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.digest = messageDigest;
        this.on = true;
    }
}

