/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    PipedInputStream sink = null;

    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }

    public void connect(PipedInputStream pipedInputStream) throws IOException {
        if (this.sink != null) {
            throw new IOException("already connected");
        }
        this.sink = pipedInputStream;
        if (pipedInputStream.src == null) {
            this.sink.connect(this);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException();
        }
        super.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        if (this.sink == null) {
            throw new IOException();
        }
        this.sink.receive(n);
    }

    public PipedOutputStream() {
    }

    public PipedOutputStream(PipedInputStream pipedInputStream) throws IOException {
        this.connect(pipedInputStream);
    }
}

