/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import kaffe.awt.JavaColorModel;

public class MemoryImageSource
implements ImageProducer {
    Vector consumers = new Vector(3);
    Hashtable props;
    int width;
    int height;
    int scan;
    int offset;
    int[] ipels;
    byte[] bpels;
    ColorModel model;
    boolean animated;
    boolean fullbuffers;

    public void addConsumer(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
    }

    private void initializeConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.width, this.height);
        imageConsumer.setColorModel(this.model);
        imageConsumer.setProperties(this.props);
        imageConsumer.setHints(ImageConsumer.TOPDOWNLEFTRIGHT | ImageConsumer.SINGLEPASS | ImageConsumer.SINGLEFRAME | ImageConsumer.COMPLETESCANLINES);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    public void newPixels(byte[] byArray, ColorModel colorModel, int n, int n2) {
        this.ipels = null;
        this.bpels = byArray;
        this.model = colorModel;
        this.offset = n;
        this.scan = n2;
        this.newPixels();
    }

    public void newPixels(int n, int n2, int n3, int n4) {
        this.newPixels(n, n2, n3, n4, true);
    }

    public void newPixels(int n, int n2, int n3, int n4, boolean bl) {
        if (!this.animated) {
            return;
        }
        if (this.fullbuffers) {
            n = 0;
            n2 = 0;
            n3 = this.width;
            n4 = this.height;
        }
        int n5 = this.consumers.size();
        int n6 = 0;
        while (n6 < n5) {
            ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(n6);
            this.transferPels(imageConsumer, n, n2, n3, n4);
            if (bl && this.isConsumer(imageConsumer)) {
                imageConsumer.setHints(ImageConsumer.SINGLEFRAMEDONE);
            }
            ++n6;
        }
    }

    public void newPixels(int[] nArray, ColorModel colorModel, int n, int n2) {
        this.bpels = null;
        this.ipels = nArray;
        this.model = colorModel;
        this.offset = n;
        this.scan = n2;
        this.newPixels();
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
        if (!bl) {
            int n = 0;
            while (n < this.consumers.size()) {
                ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(n);
                imageConsumer.imageComplete(ImageConsumer.STATICIMAGEDONE);
                ++n;
            }
            this.consumers.removeAllElements();
        }
    }

    public void setFullBufferUpdates(boolean bl) {
        this.fullbuffers = bl;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        this.initializeConsumer(imageConsumer);
        this.transferPels(imageConsumer, 0, 0, this.width, this.height);
        this.terminateConsumer(imageConsumer);
    }

    private void terminateConsumer(ImageConsumer imageConsumer) {
        imageConsumer.imageComplete(ImageConsumer.STATICIMAGEDONE);
    }

    private void transferPels(ImageConsumer imageConsumer, int n, int n2, int n3, int n4) {
        if (this.bpels != null) {
            imageConsumer.setPixels(n, n2, n3, n4, this.model, this.bpels, this.offset, this.scan);
        } else if (this.ipels != null) {
            imageConsumer.setPixels(n, n2, n3, n4, this.model, this.ipels, this.offset, this.scan);
        }
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this(n, n2, colorModel, byArray, n3, n4, (Hashtable)null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.bpels = byArray;
        this.model = colorModel;
        this.offset = n3;
        this.scan = n4;
        this.props = hashtable;
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this(n, n2, colorModel, nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.ipels = nArray;
        this.model = colorModel;
        this.offset = n3;
        this.scan = n4;
        this.props = hashtable;
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4) {
        this(n, n2, (ColorModel)JavaColorModel.getSingleton(), nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this(n, n2, (ColorModel)JavaColorModel.getSingleton(), nArray, n3, n4, hashtable);
    }
}

