/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JConditionalExpression
extends JExpression {
    private CType type;
    private JExpression cond;
    private JExpression left;
    private JExpression right;

    public CType getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JConditionalExpression[");
        stringBuffer.append(this.cond.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.cond = this.cond.analyse(cExpressionContext);
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        this.check(cExpressionContext, this.cond.getType() == CStdType.Boolean, KjcMessages.TRINARY_BADCOND);
        CType cType = this.left.getType();
        CType cType2 = this.right.getType();
        if (cType.equals(cType2)) {
            this.type = cType;
        } else if (cType.isNumeric() && cType2.isNumeric()) {
            if (cType == CStdType.Byte && cType2 == CStdType.Short || cType2 == CStdType.Byte && cType == CStdType.Short) {
                this.type = CStdType.Short;
            } else if ((cType == CStdType.Byte || cType == CStdType.Short || cType == CStdType.Char) && cType2 == CStdType.Integer && this.right.isConstant() && this.right.isAssignableTo(cType)) {
                this.type = cType;
            } else if ((cType2 == CStdType.Byte || cType2 == CStdType.Short || cType2 == CStdType.Char) && cType == CStdType.Integer && this.left.isConstant() && this.left.isAssignableTo(cType2)) {
                this.type = cType2;
            } else {
                this.type = CNumericType.binaryPromote(cType, cType2);
                this.check(cExpressionContext, this.type != null, KjcMessages.TRINARY_INCOMP, cType, cType2);
            }
            this.left = this.left.convertType(this.type, cExpressionContext);
            this.right = this.right.convertType(this.type, cExpressionContext);
        } else if (cType.isReference() && cType2.isReference()) {
            if (cType == CStdType.Null) {
                this.type = cType2;
            } else if (cType2 == CStdType.Null) {
                this.type = cType;
            } else if (cType.isAssignableTo(cType2)) {
                this.type = cType2;
            } else if (cType2.isAssignableTo(cType)) {
                this.type = cType;
            } else {
                this.check(cExpressionContext, false, KjcMessages.TRINARY_INCOMP, cType, cType2);
            }
        } else {
            this.check(cExpressionContext, false, KjcMessages.TRINARY_INCOMP, cType, cType2);
        }
        if (this.cond.isConstant() && this.left.isConstant() && this.right.isConstant()) {
            return this.cond.booleanValue() ? this.left : this.right;
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitConditionalExpression(this, this.cond, this.left, this.right);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        CodeLabel codeLabel = new CodeLabel();
        CodeLabel codeLabel2 = new CodeLabel();
        this.cond.genBranch(false, codeSequence, codeLabel);
        this.left.genCode(codeSequence, bl);
        codeSequence.plantJumpInstruction(167, codeLabel2);
        codeSequence.plantLabel(codeLabel);
        this.right.genCode(codeSequence, bl);
        codeSequence.plantLabel(codeLabel2);
    }

    public JConditionalExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2, JExpression jExpression3) {
        super(tokenReference);
        this.cond = jExpression;
        this.left = jExpression2;
        this.right = jExpression3;
    }
}

