/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JAddExpression;
import at.dms.kjc.JAssignmentExpression;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JBitwiseExpression;
import at.dms.kjc.JDivideExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JMinusExpression;
import at.dms.kjc.JModuloExpression;
import at.dms.kjc.JMultExpression;
import at.dms.kjc.JShiftExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JCompoundAssignmentExpression
extends JAssignmentExpression {
    protected int oper;

    public boolean isStatementExpression() {
        return true;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(new CExpressionContext(cExpressionContext, true, false));
        this.check(cExpressionContext, this.left.isLValue(cExpressionContext), KjcMessages.ASSIGNMENT_NOTLVALUE);
        try {
            this.left.setInitialized(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.right = this.right.analyse(new CExpressionContext(cExpressionContext, false, false));
        if (this.right instanceof JTypeNameExpression) {
            this.check((CContext)cExpressionContext, false, KjcMessages.VAR_UNKNOWN, ((JTypeNameExpression)this.right).getQualifiedName());
        }
        boolean bl = true;
        try {
            switch (this.oper) {
                case 3: {
                    this.type = JMultExpression.computeType(this.left.getType(), this.right.getType());
                    break;
                }
                case 4: {
                    this.type = JDivideExpression.computeType(this.left.getType(), this.right.getType());
                    break;
                }
                case 5: {
                    this.type = JModuloExpression.computeType(this.left.getType(), this.right.getType());
                    break;
                }
                case 1: {
                    if (this.left.getType().equals(CStdType.String)) {
                        if (this.right.getType() == CStdType.Void) {
                            throw new UnpositionedError(KjcMessages.ADD_BADTYPE, CStdType.String, CStdType.Void);
                        }
                        this.type = CStdType.String;
                        bl = false;
                        break;
                    }
                    this.type = JBinaryArithmeticExpression.computeType("+", this.left.getType(), this.right.getType());
                    break;
                }
                case 2: {
                    this.type = JMinusExpression.computeType(this.left.getType(), this.right.getType());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.type = JShiftExpression.computeType(this.left.getType(), this.right.getType());
                    bl = false;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.type = JBitwiseExpression.computeType(this.left.getType(), this.right.getType());
                    break;
                }
                default: {
                    throw new InconsistencyException("unexpected operator " + this.oper);
                }
            }
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check(cExpressionContext, this.type.isCastableTo(this.left.getType()), KjcMessages.ASSIGNMENT_BADTYPE, this.right.getType(), this.left.getType());
        if (bl && !this.right.isAssignableTo(this.left.getType())) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.NARROWING_COMPOUND_ASSIGNMENT, this.right.getType(), this.left.getType()));
        }
        this.type = this.left.getType();
        if (bl) {
            this.right = this.right.convertType(this.type, cExpressionContext);
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCompoundAssignmentExpression(this, this.oper, this.left, this.right);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        this.left.genStartStoreCode(codeSequence);
        if (this.oper == 1 && this.type.equals(CStdType.String)) {
            this.left.genCode(codeSequence, false);
            this.right.genCode(codeSequence, false);
            if (!this.right.getType().isReference()) {
                codeSequence.plantMethodRefInstruction(184, "java/lang/String", "valueOf", "(" + this.right.getType().getSignature() + ")Ljava/lang/String;");
            } else if (!this.right.getType().equals(CStdType.String)) {
                codeSequence.plantMethodRefInstruction(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            codeSequence.plantMethodRefInstruction(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        } else {
            this.left.genCode(codeSequence, false);
            this.right.genCode(codeSequence, false);
            int n = -1;
            switch (this.oper) {
                case 3: {
                    n = JMultExpression.getOpcode(this.getType());
                    break;
                }
                case 4: {
                    n = JDivideExpression.getOpcode(this.getType());
                    break;
                }
                case 5: {
                    n = JModuloExpression.getOpcode(this.getType());
                    break;
                }
                case 1: {
                    n = JAddExpression.getOpcode(this.getType());
                    break;
                }
                case 2: {
                    n = JMinusExpression.getOpcode(this.getType());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = JShiftExpression.getOpcode(this.oper, this.getType());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    n = JBitwiseExpression.getOpcode(this.oper, this.getType());
                    break;
                }
            }
            codeSequence.plantNoArgInstruction(n);
        }
        this.left.genEndStoreCode(codeSequence, bl);
    }

    public JCompoundAssignmentExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

