/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CMethodContext;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.KjcMessages;
import at.dms.util.MessageDescription;
import at.dms.util.Utils;
import java.util.Hashtable;
import java.util.Vector;

public class CBlockContext
extends CBodyContext {
    private Hashtable localClasses;
    private Vector localVars;
    private int parentIndex;
    private int localsIndex;
    private int localsPosition;

    public void close(TokenReference tokenReference) {
        this.verifyLocalVarUsed();
        super.close(tokenReference);
    }

    private void verifyLocalVarUsed() {
        int n = 0;
        while (n < this.localsIndex) {
            block8: {
                JLocalVariable jLocalVariable;
                block7: {
                    jLocalVariable = (JLocalVariable)this.localVars.elementAt(n);
                    if (jLocalVariable.isUsed() || jLocalVariable.getIdent().startsWith("_")) break block7;
                    MessageDescription messageDescription = null;
                    switch (jLocalVariable.getDescription()) {
                        case 2: {
                            messageDescription = KjcMessages.UNUSED_PARAMETER;
                            break;
                        }
                        case 4: {
                            messageDescription = KjcMessages.UNUSED_CATCH_PARAMETER;
                            break;
                        }
                        case 1: {
                            messageDescription = KjcMessages.UNUSED_LOCALVAR;
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    this.reportTrouble(new CWarning(jLocalVariable.getTokenReference(), messageDescription, (Object)jLocalVariable.getIdent()));
                    break block8;
                }
                if (jLocalVariable.getDescription() == 1 && !jLocalVariable.isFinal()) {
                    this.reportTrouble(new CWarning(jLocalVariable.getTokenReference(), KjcMessages.CONSTANT_VARIABLE_NOT_FINAL, (Object)jLocalVariable.getIdent()));
                }
            }
            ++n;
        }
    }

    public void addVariable(JLocalVariable jLocalVariable) throws UnpositionedError {
        if (this.localVars == null) {
            this.localVars = new Vector();
        }
        this.check(this.lookupLocalVariable(jLocalVariable.getIdent()) == null, KjcMessages.VARIABLE_REDECLARED, jLocalVariable.getIdent());
        jLocalVariable.setPosition(this.localsPosition);
        jLocalVariable.setIndex(this.localsIndex + this.parentIndex);
        this.localVars.addElement(jLocalVariable);
        Utils.assert(++this.localsIndex == this.localVars.size());
        this.localsPosition += jLocalVariable.getType().getSize();
    }

    public JLocalVariable lookupLocalVariable(String string) {
        if (this.localVars != null) {
            int n = 0;
            while (n < this.localsIndex) {
                JLocalVariable jLocalVariable = (JLocalVariable)this.localVars.elementAt(n);
                if (jLocalVariable.getIdent() == string) {
                    return jLocalVariable;
                }
                ++n;
            }
        }
        return this.parent.lookupLocalVariable(string);
    }

    public void addThisVariable() {
        ++this.localsPosition;
    }

    public int localsPosition() {
        return this.localsPosition;
    }

    public int localsIndex() {
        return this.parentIndex + this.localsIndex;
    }

    public CBlockContext getBlockContext() {
        return this;
    }

    public void addClass(CClass cClass) throws UnpositionedError {
        CClass cClass2;
        if (this.localClasses == null) {
            this.localClasses = new Hashtable();
        }
        if ((cClass2 = this.localClasses.put(cClass.getIdent(), cClass)) != null) {
            throw new UnpositionedError(KjcMessages.CLAZZ_RENAME, cClass.getIdent());
        }
    }

    public CClassType lookupClass(CClass cClass, String string) throws UnpositionedError {
        CClass cClass2;
        if (this.localClasses != null && (cClass2 = (CClass)this.localClasses.get(string)) != null) {
            if (cClass2.isAccessible(cClass)) {
                return cClass2.getType();
            }
            throw new UnpositionedError(KjcMessages.CLASS_NOACCESS, cClass2.getIdent());
        }
        return super.lookupClass(cClass, string);
    }

    CBlockContext(CMethodContext cMethodContext, int n) {
        super(cMethodContext);
        this.localVars = n == 0 ? null : new Vector(n);
        this.localsPosition = 0;
        this.parentIndex = 0;
    }

    public CBlockContext(CBodyContext cBodyContext) {
        this(cBodyContext, 5);
    }

    public CBlockContext(CBodyContext cBodyContext, int n) {
        super(cBodyContext);
        this.localVars = new Vector(n);
        CBlockContext cBlockContext = cBodyContext.getBlockContext();
        this.localsPosition = cBlockContext.localsPosition();
        this.parentIndex = cBlockContext.localsIndex();
    }
}

