/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.jperf;

import at.dms.compiler.tools.jperf.Graph;
import at.dms.compiler.tools.jperf.Keywords;
import at.dms.compiler.tools.jperf.Table;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class JPerf {
    private final String[] EQUALS_FUNCTION = new String[]{"  private static final boolean equals(final char[] key, int offset, int length, final char[] word) {", "    if (word.length != length) {", "      return false;", "    } else {", "      for (int i = 0; i < length; i++) {", "\t if (word[i] != key[offset + i]) {", "\t   return false;", "\t }", "      }", "      return true;", "    }", "  }"};
    private final String[] HASH_FUNCTION = new String[]{"  private static final int hash(final char[] key, int offset, int length) {", "    int\t\tf1 = 0;", "    int\t\tf2 = 0;", "", "    for (int i = 0; i < length; i++) {", "      char\tc = key[i + offset];", "", "      if (c < MIN_CHAR_VAL || c > MAX_CHAR_VAL) {", "\treturn -1;", "      }", "", "      int\tt1 = T1[i][c - MIN_CHAR_VAL];", "      if (t1 == -1) {", "\treturn -1;", "      }", "", "      int\tt2 = T2[i][c - MIN_CHAR_VAL];", "      if (t2 == -1) {", "\treturn -1;", "      }", "", "      f1 += t1;", "      f2 += t2;", "    }", "", "    f1 %= MAX_GRAPH_NODE_VAL;", "    f2 %= MAX_GRAPH_NODE_VAL;", "", "    return (gIndex(f1)+gIndex(f2)) % TOTAL_KEYWORDS;", "  }"};
    private final String[] FIND_FUNCTION = new String[]{"  private static final int find(final char[] key, int offset, int length) {", "    if (length <= MAX_WORD_LENG && length >= MIN_WORD_LENG) {", "      int\tind = hash(key, offset, length);", "", "      if (ind < TOTAL_KEYWORDS && ind >= 0) {", "\tif (equals(key, offset, length, keywords[ind])) {", "\t  return ind;", "\t}", "      }", "    }", "    return -1;", "  }"};
    private final Keywords keywords;
    private final String[] header;
    private final String[] footer;
    private final long maxNodeCount;
    private Table table1;
    private Table table2;
    private Graph graph;

    public void build() {
        boolean bl;
        this.table1 = new Table("T1", this.keywords.getMaxWordLength(), this.keywords.getMinCharValue(), this.keywords.getMaxCharValue());
        this.table2 = new Table("T2", this.keywords.getMaxWordLength(), this.keywords.getMinCharValue(), this.keywords.getMaxCharValue());
        this.graph = new Graph(this.maxNodeCount);
        do {
            this.table1.init();
            this.table2.init();
            this.graph.init();
            bl = true;
            int n = 0;
            while (bl && n < this.keywords.size()) {
                bl = this.addKey(this.keywords.elementAt(n), n);
                ++n;
            }
        } while (!bl);
        this.graph.assignGValues(this.keywords.size());
    }

    private boolean addKey(String string, long l) {
        long l2 = this.table1.insertKey(string, this.maxNodeCount);
        long l3 = this.table2.insertKey(string, this.maxNodeCount);
        return this.graph.addEdge(l2, l3, l);
    }

    public void genCode(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string, false), true);
        this.printStringArray(printWriter, this.header);
        printWriter.println();
        printWriter.println(" // --------------------------------------------------------------------");
        printWriter.println(" // CODE GENERATED BY JPERF STARTS HERE");
        printWriter.println();
        printWriter.println("  private static final int MAX_GRAPH_NODE_VAL = " + this.maxNodeCount + ";");
        printWriter.println();
        this.keywords.genCode(printWriter);
        printWriter.println();
        this.table1.genCode(printWriter);
        this.table2.genCode(printWriter);
        printWriter.println();
        this.graph.genCode(printWriter);
        printWriter.println();
        printWriter.println();
        this.printStringArray(printWriter, this.EQUALS_FUNCTION);
        printWriter.println();
        this.printStringArray(printWriter, this.HASH_FUNCTION);
        printWriter.println();
        this.printStringArray(printWriter, this.FIND_FUNCTION);
        printWriter.println();
        printWriter.println(" // CODE GENERATED BY JPERF ENDS HERE");
        printWriter.println(" // --------------------------------------------------------------------");
        printWriter.println();
        this.printStringArray(printWriter, this.footer);
        printWriter.close();
    }

    private void printStringArray(PrintWriter printWriter, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println(stringArray[n]);
            ++n;
        }
    }

    public JPerf(String[] stringArray, String[] stringArray2, String[] stringArray3, double d) {
        this.keywords = new Keywords(stringArray);
        this.header = stringArray2;
        this.footer = stringArray3;
        this.maxNodeCount = (long)Math.ceil(d * (double)stringArray.length);
    }

    public JPerf(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this(stringArray, stringArray2, stringArray3, 2.0833333333333335);
    }
}

