/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.LocalVariableInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("LocalVariableTable");
    private LocalVariableInfo[] entries;

    int getTag() {
        return 6;
    }

    int getSize() {
        return 8 + 10 * this.entries.length;
    }

    LocalVariableInfo[] getLocalVariables() {
        return this.entries;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(attr);
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].resolveConstants(constantPool);
            ++n;
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(this.getSize() - 6);
        dataOutput.writeShort(this.entries.length);
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].write(constantPool, dataOutput);
            ++n;
        }
    }

    public LocalVariableTable(LocalVariableInfo[] localVariableInfoArray) {
        this.entries = localVariableInfoArray;
    }

    public LocalVariableTable(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException {
        dataInput.readInt();
        this.entries = new LocalVariableInfo[dataInput.readUnsignedShort()];
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n] = new LocalVariableInfo(dataInput, constantPool, instructionArray);
            ++n;
        }
    }
}

