/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVarInstruction
extends Instruction {
    public static final byte KND_LOAD = 1;
    public static final byte KND_STORE = 2;
    public static final byte KND_RET = 3;
    private int index;
    private int width;

    public boolean canComplete() {
        return this.getOpcode() != 169;
    }

    int getSize() {
        return this.width;
    }

    public int getIndex() {
        return this.index;
    }

    public byte getReturnType() {
        return this.getOperandType();
    }

    public byte getOperandType() {
        switch (this.getOpcode()) {
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return 6;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return 2;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return 3;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return 4;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return 5;
            }
            case 169: {
                return 1;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    public byte getOperationKind() {
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 1;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return 2;
            }
            case 169: {
                return 3;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    int getLocalVar() {
        switch (this.getOperandType()) {
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return this.index;
            }
            case 2: 
            case 5: {
                return this.index + 1;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    public boolean isLoad() {
        return this.getStack() > 0;
    }

    public boolean isStore() {
        return this.getStack() < 0;
    }

    public int getPushedOnStack() {
        return this.isLoad() ? this.getStack() : 0;
    }

    public int getStack() {
        switch (this.getOpcode()) {
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return -2;
            }
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return -1;
            }
            case 169: {
                return 0;
            }
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 1;
            }
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 2;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    void resolveConstants(ConstantPool constantPool) {
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        if (this.width == 4) {
            dataOutput.writeByte(-60);
        }
        dataOutput.writeByte((byte)this.getOpcode());
        if (this.width == 2) {
            dataOutput.writeByte((byte)(this.index & 0xFF));
        } else if (this.width == 4) {
            dataOutput.writeShort((short)(this.index & 0xFFFF));
        }
    }

    public LocalVarInstruction(int n, int n2) {
        super(n);
        this.index = n2;
        if (n2 > 255) {
            this.width = 4;
        } else if (n2 > 3) {
            this.width = 2;
        } else {
            switch (n) {
                case 21: {
                    this.setOpcode(26 + n2);
                    this.width = 1;
                    break;
                }
                case 23: {
                    this.setOpcode(34 + n2);
                    this.width = 1;
                    break;
                }
                case 25: {
                    this.setOpcode(42 + n2);
                    this.width = 1;
                    break;
                }
                case 22: {
                    this.setOpcode(30 + n2);
                    this.width = 1;
                    break;
                }
                case 24: {
                    this.setOpcode(38 + n2);
                    this.width = 1;
                    break;
                }
                case 54: {
                    this.setOpcode(59 + n2);
                    this.width = 1;
                    break;
                }
                case 56: {
                    this.setOpcode(67 + n2);
                    this.width = 1;
                    break;
                }
                case 58: {
                    this.setOpcode(75 + n2);
                    this.width = 1;
                    break;
                }
                case 55: {
                    this.setOpcode(63 + n2);
                    this.width = 1;
                    break;
                }
                case 57: {
                    this.setOpcode(71 + n2);
                    this.width = 1;
                    break;
                }
                default: {
                    this.width = 2;
                }
            }
        }
    }
}

