/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassRefInstruction;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Constants;
import at.dms.classfile.FieldRefConstant;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.IincInstruction;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.InterfaceConstant;
import at.dms.classfile.InvokeinterfaceInstruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.MethodRefConstant;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.MultiarrayInstruction;
import at.dms.classfile.NewarrayInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.classfile.SwitchInstruction;
import at.dms.util.InconsistencyException;
import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class InstructionIO
implements Constants {
    private DataInput in;
    private ConstantPool cp;
    private Vector forwards;
    private Vector switches;
    private Instruction[] instructions;

    public static Instruction[] read(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        InstructionIO instructionIO = new InstructionIO(dataInput, constantPool);
        instructionIO.readInstructions();
        instructionIO.resolveReferences();
        instructionIO.selectSwitchTypes();
        return instructionIO.instructions;
    }

    private void readInstructions() throws IOException, ClassFileFormatException {
        int n = this.in.readInt();
        this.instructions = new Instruction[n];
        boolean bl = false;
        int n2 = 0;
        block75: while (n2 < n) {
            int n3 = this.in.readUnsignedByte();
            int n4 = 0;
            switch (n3) {
                case 0: 
                case 1: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    this.instructions[n2] = new NoArgInstruction(n3);
                    break;
                }
                case 2: {
                    this.instructions[n2] = new PushLiteralInstruction(-1);
                    break;
                }
                case 3: {
                    this.instructions[n2] = new PushLiteralInstruction(0);
                    break;
                }
                case 4: {
                    this.instructions[n2] = new PushLiteralInstruction(1);
                    break;
                }
                case 5: {
                    this.instructions[n2] = new PushLiteralInstruction(2);
                    break;
                }
                case 6: {
                    this.instructions[n2] = new PushLiteralInstruction(3);
                    break;
                }
                case 7: {
                    this.instructions[n2] = new PushLiteralInstruction(4);
                    break;
                }
                case 8: {
                    this.instructions[n2] = new PushLiteralInstruction(5);
                    break;
                }
                case 9: {
                    this.instructions[n2] = new PushLiteralInstruction(0L);
                    break;
                }
                case 10: {
                    this.instructions[n2] = new PushLiteralInstruction(1L);
                    break;
                }
                case 11: {
                    this.instructions[n2] = new PushLiteralInstruction(0.0f);
                    break;
                }
                case 12: {
                    this.instructions[n2] = new PushLiteralInstruction(1.0f);
                    break;
                }
                case 13: {
                    this.instructions[n2] = new PushLiteralInstruction(2.0f);
                    break;
                }
                case 14: {
                    this.instructions[n2] = new PushLiteralInstruction(0.0);
                    break;
                }
                case 15: {
                    this.instructions[n2] = new PushLiteralInstruction(1.0);
                    break;
                }
                case 16: {
                    this.instructions[n2] = new PushLiteralInstruction(this.in.readByte());
                    n4 = 1;
                    break;
                }
                case 17: {
                    this.instructions[n2] = new PushLiteralInstruction(this.in.readShort());
                    n4 = 2;
                    break;
                }
                case 18: {
                    this.instructions[n2] = new PushLiteralInstruction(this.cp.getEntryAt(this.in.readUnsignedByte()), false);
                    n4 = 1;
                    break;
                }
                case 19: {
                    this.instructions[n2] = new PushLiteralInstruction(this.cp.getEntryAt(this.in.readUnsignedShort()), false);
                    n4 = 2;
                    break;
                }
                case 20: {
                    this.instructions[n2] = new PushLiteralInstruction(this.cp.getEntryAt(this.in.readUnsignedShort()), true);
                    n4 = 2;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    if (bl) {
                        bl = false;
                        this.instructions[n2] = new LocalVarInstruction(n3, this.in.readUnsignedShort());
                        n4 = 3;
                        break;
                    }
                    this.instructions[n2] = new LocalVarInstruction(n3, this.in.readUnsignedByte());
                    n4 = 1;
                    break;
                }
                case 26: {
                    this.instructions[n2] = new LocalVarInstruction(21, 0);
                    break;
                }
                case 27: {
                    this.instructions[n2] = new LocalVarInstruction(21, 1);
                    break;
                }
                case 28: {
                    this.instructions[n2] = new LocalVarInstruction(21, 2);
                    break;
                }
                case 29: {
                    this.instructions[n2] = new LocalVarInstruction(21, 3);
                    break;
                }
                case 30: {
                    this.instructions[n2] = new LocalVarInstruction(22, 0);
                    break;
                }
                case 31: {
                    this.instructions[n2] = new LocalVarInstruction(22, 1);
                    break;
                }
                case 32: {
                    this.instructions[n2] = new LocalVarInstruction(22, 2);
                    break;
                }
                case 33: {
                    this.instructions[n2] = new LocalVarInstruction(22, 3);
                    break;
                }
                case 34: {
                    this.instructions[n2] = new LocalVarInstruction(23, 0);
                    break;
                }
                case 35: {
                    this.instructions[n2] = new LocalVarInstruction(23, 1);
                    break;
                }
                case 36: {
                    this.instructions[n2] = new LocalVarInstruction(23, 2);
                    break;
                }
                case 37: {
                    this.instructions[n2] = new LocalVarInstruction(23, 3);
                    break;
                }
                case 38: {
                    this.instructions[n2] = new LocalVarInstruction(24, 0);
                    break;
                }
                case 39: {
                    this.instructions[n2] = new LocalVarInstruction(24, 1);
                    break;
                }
                case 40: {
                    this.instructions[n2] = new LocalVarInstruction(24, 2);
                    break;
                }
                case 41: {
                    this.instructions[n2] = new LocalVarInstruction(24, 3);
                    break;
                }
                case 42: {
                    this.instructions[n2] = new LocalVarInstruction(25, 0);
                    break;
                }
                case 43: {
                    this.instructions[n2] = new LocalVarInstruction(25, 1);
                    break;
                }
                case 44: {
                    this.instructions[n2] = new LocalVarInstruction(25, 2);
                    break;
                }
                case 45: {
                    this.instructions[n2] = new LocalVarInstruction(25, 3);
                    break;
                }
                case 59: {
                    this.instructions[n2] = new LocalVarInstruction(54, 0);
                    break;
                }
                case 60: {
                    this.instructions[n2] = new LocalVarInstruction(54, 1);
                    break;
                }
                case 61: {
                    this.instructions[n2] = new LocalVarInstruction(54, 2);
                    break;
                }
                case 62: {
                    this.instructions[n2] = new LocalVarInstruction(54, 3);
                    break;
                }
                case 63: {
                    this.instructions[n2] = new LocalVarInstruction(55, 0);
                    break;
                }
                case 64: {
                    this.instructions[n2] = new LocalVarInstruction(55, 1);
                    break;
                }
                case 65: {
                    this.instructions[n2] = new LocalVarInstruction(55, 2);
                    break;
                }
                case 66: {
                    this.instructions[n2] = new LocalVarInstruction(55, 3);
                    break;
                }
                case 67: {
                    this.instructions[n2] = new LocalVarInstruction(56, 0);
                    break;
                }
                case 68: {
                    this.instructions[n2] = new LocalVarInstruction(56, 1);
                    break;
                }
                case 69: {
                    this.instructions[n2] = new LocalVarInstruction(56, 2);
                    break;
                }
                case 70: {
                    this.instructions[n2] = new LocalVarInstruction(56, 3);
                    break;
                }
                case 71: {
                    this.instructions[n2] = new LocalVarInstruction(57, 0);
                    break;
                }
                case 72: {
                    this.instructions[n2] = new LocalVarInstruction(57, 1);
                    break;
                }
                case 73: {
                    this.instructions[n2] = new LocalVarInstruction(57, 2);
                    break;
                }
                case 74: {
                    this.instructions[n2] = new LocalVarInstruction(57, 3);
                    break;
                }
                case 75: {
                    this.instructions[n2] = new LocalVarInstruction(58, 0);
                    break;
                }
                case 76: {
                    this.instructions[n2] = new LocalVarInstruction(58, 1);
                    break;
                }
                case 77: {
                    this.instructions[n2] = new LocalVarInstruction(58, 2);
                    break;
                }
                case 78: {
                    this.instructions[n2] = new LocalVarInstruction(58, 3);
                    break;
                }
                case 132: {
                    if (bl) {
                        bl = false;
                        this.instructions[n2] = new IincInstruction(this.in.readUnsignedShort(), this.in.readShort());
                        n4 = 5;
                        break;
                    }
                    this.instructions[n2] = new IincInstruction(this.in.readUnsignedByte(), this.in.readByte());
                    n4 = 2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n5 = n2 + this.in.readShort();
                    if (n5 < 0 || n5 >= this.instructions.length) {
                        throw new InconsistencyException();
                    }
                    if (n5 < n2) {
                        this.instructions[n2] = new JumpInstruction(n3, this.instructions[n5]);
                    } else {
                        this.instructions[n2] = new JumpInstruction(n3, new ForwardReference(n5));
                        this.forwards.addElement(this.instructions[n2]);
                    }
                    n4 = 2;
                    break;
                }
                case 200: 
                case 201: {
                    int n6 = n2 + this.in.readInt();
                    if (n6 < 0 || n6 >= this.instructions.length) {
                        throw new InconsistencyException();
                    }
                    if (n6 < n2) {
                        this.instructions[n2] = new JumpInstruction(n3, this.instructions[n6]);
                    } else {
                        this.instructions[n2] = new JumpInstruction(n3, new ForwardReference(n6));
                        this.forwards.addElement(this.instructions[n2]);
                    }
                    n4 = 4;
                    break;
                }
                case 170: {
                    n4 = this.readTableSwitch(n2);
                    break;
                }
                case 171: {
                    n4 = this.readLookupSwitch(n2);
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    this.instructions[n2] = new FieldRefInstruction(n3, (FieldRefConstant)this.cp.getEntryAt(this.in.readUnsignedShort()));
                    n4 = 2;
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    this.instructions[n2] = new MethodRefInstruction(n3, (MethodRefConstant)this.cp.getEntryAt(this.in.readUnsignedShort()));
                    n4 = 2;
                    break;
                }
                case 185: {
                    InterfaceConstant interfaceConstant = (InterfaceConstant)this.cp.getEntryAt(this.in.readUnsignedShort());
                    int n7 = this.in.readUnsignedByte();
                    this.in.readUnsignedByte();
                    this.instructions[n2] = new InvokeinterfaceInstruction(interfaceConstant, n7);
                    n4 = 4;
                    break;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    this.instructions[n2] = new ClassRefInstruction(n3, (ClassConstant)this.cp.getEntryAt(this.in.readUnsignedShort()));
                    n4 = 2;
                    break;
                }
                case 188: {
                    this.instructions[n2] = new NewarrayInstruction((byte)this.in.readUnsignedByte());
                    n4 = 1;
                    break;
                }
                case 197: {
                    this.instructions[n2] = new MultiarrayInstruction((ClassConstant)this.cp.getEntryAt(this.in.readUnsignedShort()), this.in.readUnsignedByte());
                    n4 = 3;
                    break;
                }
                case 196: {
                    bl = true;
                    continue block75;
                }
                default: {
                    throw new ClassFileFormatException("read invalid opcode: " + n3);
                }
            }
            n2 += 1 + n4;
        }
    }

    private void resolveReferences() throws ClassFileFormatException {
        InstructionIO instructionIO = this;
        if (instructionIO == null) {
            throw null;
        }
        AccessorTransformer accessorTransformer = new AccessorTransformer(instructionIO){
            private final /* synthetic */ InstructionIO this$0;

            public InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) throws BadAccessorException {
                if (!(instructionAccessor instanceof ForwardReference)) {
                    return instructionAccessor;
                }
                int n = ((ForwardReference)instructionAccessor).getIndex();
                if (InstructionIO.access$0(this.this$0)[n] == null) {
                    throw new BadAccessorException("no instruction at " + n);
                }
                return InstructionIO.access$0(this.this$0)[n];
            }
            {
                this.this$0 = instructionIO;
                this.constructor$0(instructionIO);
            }

            private final void constructor$0(InstructionIO instructionIO) {
            }
        };
        Enumeration enumeration = this.forwards.elements();
        while (enumeration.hasMoreElements()) {
            AccessorContainer accessorContainer = (AccessorContainer)enumeration.nextElement();
            try {
                accessorContainer.transformAccessors(accessorTransformer);
            }
            catch (BadAccessorException badAccessorException) {
                throw new ClassFileFormatException("forward reference not resolvable");
            }
        }
    }

    private void selectSwitchTypes() {
    }

    private int readTableSwitch(int n) throws IOException {
        AbstractInstructionAccessor abstractInstructionAccessor;
        int n2 = 0;
        int n3 = n + 1;
        while (n3 % 4 != 0) {
            ++n2;
            this.in.readUnsignedByte();
            ++n3;
        }
        boolean bl = false;
        int n4 = n + this.in.readInt();
        if (n4 < n) {
            abstractInstructionAccessor = this.instructions[n4];
        } else {
            abstractInstructionAccessor = new ForwardReference(n4);
            bl = true;
        }
        int n5 = this.in.readInt();
        int n6 = this.in.readInt() - n5 + 1;
        int[] nArray = new int[n6];
        InstructionAccessor[] instructionAccessorArray = new InstructionAccessor[n6];
        int n7 = 0;
        while (n7 < n6) {
            nArray[n7] = n5 + n7;
            n4 = n + this.in.readInt();
            if (n4 < n) {
                instructionAccessorArray[n7] = this.instructions[n4];
            } else {
                instructionAccessorArray[n7] = new ForwardReference(n4);
                bl = true;
            }
            ++n7;
        }
        this.instructions[n] = new SwitchInstruction(170, abstractInstructionAccessor, nArray, instructionAccessorArray);
        n2 += 12 + 4 * n6;
        if (bl) {
            this.forwards.addElement(this.instructions[n]);
        }
        this.switches.addElement(this.instructions[n]);
        return n2;
    }

    private int readLookupSwitch(int n) throws IOException {
        AbstractInstructionAccessor abstractInstructionAccessor;
        int n2 = 0;
        int n3 = n + 1;
        while (n3 % 4 != 0) {
            ++n2;
            this.in.readUnsignedByte();
            ++n3;
        }
        boolean bl = false;
        int n4 = n + this.in.readInt();
        if (n4 < n) {
            abstractInstructionAccessor = this.instructions[n4];
        } else {
            abstractInstructionAccessor = new ForwardReference(n4);
            bl = true;
        }
        int n5 = this.in.readInt();
        int[] nArray = new int[n5];
        InstructionAccessor[] instructionAccessorArray = new InstructionAccessor[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = this.in.readInt();
            n4 = n + this.in.readInt();
            if (n4 < n) {
                instructionAccessorArray[n6] = this.instructions[n4];
            } else {
                instructionAccessorArray[n6] = new ForwardReference(n4);
                bl = true;
            }
            ++n6;
        }
        this.instructions[n] = new SwitchInstruction(171, abstractInstructionAccessor, nArray, instructionAccessorArray);
        n2 += 8 + 8 * n5;
        if (bl) {
            this.forwards.addElement(this.instructions[n]);
        }
        this.switches.addElement(this.instructions[n]);
        return n2;
    }

    static /* synthetic */ Instruction[] access$0(InstructionIO instructionIO) {
        return instructionIO.instructions;
    }

    private InstructionIO(DataInput dataInput, ConstantPool constantPool) {
        this.in = dataInput;
        this.cp = constantPool;
        this.forwards = new Vector();
        this.switches = new Vector();
    }

    private static class ForwardReference
    extends AbstractInstructionAccessor {
        private final int index;

        public int getIndex() {
            return this.index;
        }

        ForwardReference(int n) {
            this.index = n;
        }
    }
}

