/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BackendMessages;
import at.dms.backend.BackendOptions;
import at.dms.backend.Optimizer;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassInfo;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.MethodInfo;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.UnpositionedError;
import at.dms.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Main {
    protected BackendOptions options;

    private void optimizeClass(String string) throws UnpositionedError {
        ClassInfo classInfo = this.readClassFile(string);
        Main.optimizeClass(classInfo, this.options);
        this.writeClassFile(classInfo, this.options.destination == null ? string : this.options.destination + File.separatorChar + Utils.splitQualifiedName(classInfo.getName())[1] + ".class");
    }

    public static void optimizeClass(ClassInfo classInfo, BackendOptions backendOptions) throws UnpositionedError {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        MethodInfo[] methodInfoArray = classInfo.getMethods();
        int n4 = 0;
        while (n4 < methodInfoArray.length) {
            if (methodInfoArray[n4].getCodeInfo() != null) {
                if (backendOptions.verbose) {
                    n = methodInfoArray[n4].getCodeInfo().getInstructions().length;
                }
                Main.optimizeMethod(methodInfoArray[n4], backendOptions);
                if (backendOptions.verbose) {
                    CodeInfo codeInfo = methodInfoArray[n4].getCodeInfo();
                    System.err.println(methodInfoArray[n4].getName() + "\t[" + (double)codeInfo.getInstructions().length * 100.0 / (double)n + "]" + n + " / " + codeInfo.getInstructions().length);
                    n2 += n;
                    n3 += codeInfo.getInstructions().length;
                }
            }
            ++n4;
        }
        if (backendOptions.verbose) {
            System.err.println("TOTAL:\t[" + (double)n3 * 100.0 / (double)n2 + "]" + n3 + " / " + n2);
        }
    }

    private static void optimizeMethod(MethodInfo methodInfo, BackendOptions backendOptions) {
        CodeInfo codeInfo = methodInfo.getCodeInfo();
        if (codeInfo != null) {
            long l = codeInfo.getInstructions().length;
            codeInfo = Optimizer.optimize(methodInfo, codeInfo, backendOptions);
            methodInfo.setCodeInfo(codeInfo);
        }
    }

    private ClassInfo readClassFile(String string) throws UnpositionedError {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048));
            ClassInfo classInfo = new ClassInfo(dataInputStream, false);
            dataInputStream.close();
            return classInfo;
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(BackendMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    private void writeClassFile(ClassInfo classInfo, String string) throws UnpositionedError {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            classInfo.write(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(BackendMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new BackendOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private Main(String[] stringArray) {
        String[] stringArray2;
        if (!this.parseArguments(stringArray)) {
            System.exit(1);
        }
        if ((stringArray2 = this.options.nonOptions).length == 0) {
            this.options.usage();
            System.err.println(CompilerMessages.NO_INPUT_FILE);
            System.exit(1);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < stringArray2.length) {
                if (this.options.verbose) {
                    System.err.println("Processing " + stringArray2[n] + ".");
                }
                try {
                    this.optimizeClass(stringArray2[n]);
                }
                catch (UnpositionedError unpositionedError) {
                    System.err.println("Error: " + unpositionedError.getMessage());
                    bl = true;
                }
                ++n;
            }
            System.exit(bl ? 1 : 0);
        }
    }
}

