/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.CodeSequence;
import at.dms.backend.DeadcodeElimination;
import at.dms.backend.InstructionHandle;
import at.dms.backend.LivenessAnalysis;
import at.dms.backend.MethodEnv;
import at.dms.backend.RegisterAllocation;
import at.dms.backend.StackSchleduler;
import at.dms.backend.TraceControlFlow;
import at.dms.backend.TraceInferenceGraph;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.SwitchInstruction;
import at.dms.util.Utils;
import java.util.Vector;

public class ControlFlow {
    private MethodEnv env;
    private BasicBlock[] bblocks;
    private BasicBlock[] eblocks;
    private static /* synthetic */ Class class$Lat$dms$backend$InstructionHandle;
    private static /* synthetic */ Class class$Lat$dms$backend$BasicBlock;

    public void trace() {
        new TraceControlFlow(this.bblocks, this.eblocks).run();
    }

    public void optimize() {
        LivenessAnalysis livenessAnalysis = new LivenessAnalysis(this.bblocks, this.eblocks);
        livenessAnalysis.run();
        this.trace();
        new DeadcodeElimination(this.bblocks, this.eblocks).run();
        new StackSchleduler(this.bblocks, this.eblocks).run();
        RegisterAllocation registerAllocation = new RegisterAllocation(this.env, this.bblocks, this.eblocks, livenessAnalysis);
        registerAllocation.run();
        new TraceInferenceGraph(registerAllocation.getInferenceGraph()).run();
    }

    public InstructionHandle getInstructions() {
        this.setMarked(false);
        CodeSequence codeSequence = new CodeSequence();
        codeSequence.plantBasicBlock(this.bblocks[0]);
        codeSequence.close();
        int n = 0;
        while (n < this.eblocks.length) {
            codeSequence.plantBasicBlock(this.eblocks[n]);
            ++n;
        }
        this.resolveAccessors(codeSequence.getCodeStart());
        n = 0;
        while (n < this.eblocks.length) {
            this.resolveAccessors(this.eblocks[n].getFirstInstruction());
            ++n;
        }
        return codeSequence.getCodeStart();
    }

    public static BasicBlock findBasicBlock(InstructionHandle instructionHandle) {
        int n = 0;
        while (!(instructionHandle.getAccessor(n) instanceof BasicBlock)) {
            ++n;
        }
        return (BasicBlock)instructionHandle.getAccessor(n);
    }

    private void buildBasicBlocks(InstructionHandle instructionHandle, HandlerInfo[] handlerInfoArray) {
        Vector vector = new Vector();
        Vector<InstructionHandle> vector2 = new Vector<InstructionHandle>();
        BasicBlock basicBlock = null;
        boolean bl = true;
        int n = 0;
        InstructionHandle instructionHandle2 = instructionHandle;
        while (instructionHandle2 != null) {
            if (instructionHandle2.isTarget() || bl) {
                if (basicBlock != null && !basicBlock.isMarked()) {
                    this.closeBasicBlock(basicBlock, vector2, vector);
                }
                basicBlock = new BasicBlock(n++);
                instructionHandle2.addAccessor(basicBlock);
                vector2.addElement(instructionHandle2);
                bl = ControlFlow.isEndOfBasicBlock(instructionHandle2);
            } else if (ControlFlow.isEndOfBasicBlock(instructionHandle2)) {
                vector2.addElement(instructionHandle2);
                this.closeBasicBlock(basicBlock, vector2, vector);
                bl = true;
            } else {
                vector2.addElement(instructionHandle2);
            }
            instructionHandle2 = instructionHandle2.getNext();
        }
        if (vector2.size() != 0) {
            this.closeBasicBlock(basicBlock, vector2, vector);
        }
        this.clean(handlerInfoArray, vector);
    }

    private void closeBasicBlock(BasicBlock basicBlock, Vector vector, Vector vector2) {
        basicBlock.setBody((InstructionHandle[])Utils.toArray(vector, class$Lat$dms$backend$InstructionHandle != null ? class$Lat$dms$backend$InstructionHandle : (class$Lat$dms$backend$InstructionHandle = ControlFlow.class$("at.dms.backend.InstructionHandle"))));
        vector.setSize(0);
        vector2.addElement(basicBlock);
        basicBlock.setMarked(true);
    }

    private void clean(HandlerInfo[] handlerInfoArray, Vector vector) {
        this.bblocks = (BasicBlock[])Utils.toArray(vector, class$Lat$dms$backend$BasicBlock != null ? class$Lat$dms$backend$BasicBlock : (class$Lat$dms$backend$BasicBlock = ControlFlow.class$("at.dms.backend.BasicBlock")));
        int n = 0;
        while (n < this.bblocks.length) {
            this.bblocks[n].resolveJump();
            ++n;
        }
        this.eblocks = new BasicBlock[handlerInfoArray.length];
        n = 0;
        while (n < handlerInfoArray.length) {
            this.eblocks[n] = ControlFlow.findBasicBlock((InstructionHandle)handlerInfoArray[n].getHandler());
            ++n;
        }
        InstructionHandle instructionHandle = this.bblocks[0].getFirstInstruction();
        while (instructionHandle != null) {
            InstructionHandle instructionHandle2 = instructionHandle;
            instructionHandle.removeAccessors();
            instructionHandle = instructionHandle.getNext();
            instructionHandle2.setNext(null);
        }
    }

    private static boolean isEndOfBasicBlock(InstructionHandle instructionHandle) {
        return instructionHandle.isJump() || !instructionHandle.getInstruction().canComplete();
    }

    private void setMarked(boolean bl) {
        ControlFlow.setMarked(this.bblocks, bl);
    }

    protected static final void setMarked(BasicBlock[] basicBlockArray, boolean bl) {
        int n = 0;
        while (n < basicBlockArray.length) {
            basicBlockArray[n].setMarked(bl);
            ++n;
        }
    }

    private void resolveAccessors(InstructionHandle instructionHandle) {
        while (instructionHandle != null) {
            if (instructionHandle.isJump()) {
                instructionHandle.setTarget(((BasicBlock)instructionHandle.getJump().getTarget()).getFirstInstruction());
            } else if (instructionHandle.getInstruction() instanceof SwitchInstruction) {
                SwitchInstruction switchInstruction = (SwitchInstruction)instructionHandle.getInstruction();
                int n = -1;
                while (n < switchInstruction.getSwitchCount()) {
                    switchInstruction.setTarget(((BasicBlock)switchInstruction.getTarget(n)).getFirstInstruction(), n);
                    ++n;
                }
            }
            instructionHandle = instructionHandle.getNext();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ControlFlow(MethodEnv methodEnv, InstructionHandle instructionHandle, HandlerInfo[] handlerInfoArray) {
        this.env = methodEnv;
        this.buildBasicBlocks(instructionHandle, handlerInfoArray);
        this.setMarked(false);
        this.bblocks[0].buildQuadruples(methodEnv);
    }
}

