/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.CodeSequence;
import at.dms.backend.ControlFlow;
import at.dms.backend.InstructionHandle;
import at.dms.backend.MethodEnv;
import at.dms.backend.QNode;
import at.dms.backend.QQuadruple;
import at.dms.backend.QTemporary;
import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.SwitchInstruction;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Vector;

class BasicBlock
extends AbstractInstructionAccessor
implements AccessorContainer {
    private InstructionHandle[] insns;
    private InstructionHandle firstInstruction;
    private QNode[] quads;
    private QTemporary[] remainingStack;
    private QTemporary[] entryStack;
    private boolean marked;
    private BasicBlock next;
    private BasicBlock[] successors;
    private QQuadruple[][] successorAccess;
    private int pos;
    private static /* synthetic */ Class class$Lat$dms$backend$QNode;

    public int getPosition() {
        return this.pos;
    }

    public QNode[] getQuadruples() {
        return this.quads;
    }

    public BasicBlock[] getSuccessors() {
        return this.successors;
    }

    public QNode[][] getSuccessorAccess() {
        return this.successorAccess;
    }

    public QNode[] getSuccessorNodes(int n, int n2) {
        if (n < this.quads.length - 1 && n2 == -1) {
            return new QNode[]{this.quads[n + 1]};
        }
        if (n2 == -1) {
            QNode[] qNodeArray = new QNode[this.successors.length];
            int n3 = 0;
            while (n3 < qNodeArray.length) {
                qNodeArray[n3] = this.successorAccess[n3].length != 0 ? this.successorAccess[n3][0] : this.successors[n3].getSuccessorNodes(0, -1)[0];
                ++n3;
            }
            return qNodeArray;
        }
        if (n != this.successorAccess[n2].length - 1) {
            return new QNode[]{this.successorAccess[n2][n + 1]};
        }
        return this.successors[n2].getSuccessorNodes(0, -1);
    }

    public void setNext(BasicBlock basicBlock) {
        this.next = basicBlock;
    }

    public void setBody(InstructionHandle[] instructionHandleArray) {
        this.insns = instructionHandleArray;
    }

    public void setBody(QQuadruple[] qQuadrupleArray) {
        this.quads = qQuadrupleArray;
    }

    public final InstructionHandle getFirstInstruction() {
        return this.firstInstruction;
    }

    public final QNode getLastNode() {
        return this.quads.length == 0 ? null : this.quads[this.quads.length - 1];
    }

    public void buildQuadruples(MethodEnv methodEnv) {
        if (this.isMarked()) {
            return;
        }
        this.setMarked(true);
        Vector vector = new Vector();
        this.remainingStack = QQuadruple.buildQuadruples(methodEnv, this, this.insns, this.entryStack, vector);
        this.quads = (QNode[])Utils.toArray(vector, class$Lat$dms$backend$QNode != null ? class$Lat$dms$backend$QNode : (class$Lat$dms$backend$QNode = BasicBlock.class$("at.dms.backend.QNode")));
        this.insns = null;
        BasicBlock[] basicBlockArray = this.buildSuccessorList();
        this.successorAccess = new QQuadruple[basicBlockArray.length][];
        int n = 0;
        while (n < basicBlockArray.length) {
            int n2;
            if (basicBlockArray[n].entryStack != null) {
                this.successorAccess[n] = new QQuadruple[this.remainingStack.length];
                n2 = this.remainingStack.length - 1;
                while (n2 >= 0) {
                    this.successorAccess[n][n2] = new QQuadruple(basicBlockArray[n].entryStack[n2], this.remainingStack[n2]);
                    --n2;
                }
            } else {
                basicBlockArray[n].entryStack = new QTemporary[this.remainingStack.length];
                n2 = this.remainingStack.length - 1;
                while (n2 >= 0) {
                    basicBlockArray[n].entryStack[n2] = new QTemporary(this.remainingStack[n2].getType());
                    --n2;
                }
                this.successorAccess[n] = new QQuadruple[this.remainingStack.length];
                n2 = this.remainingStack.length - 1;
                while (n2 >= 0) {
                    this.successorAccess[n][n2] = new QQuadruple(basicBlockArray[n].entryStack[n2], this.remainingStack[n2]);
                    --n2;
                }
            }
            basicBlockArray[n].buildQuadruples(methodEnv);
            ++n;
        }
    }

    public void generateQuadruple(CodeSequence codeSequence) {
        BasicBlock[] basicBlockArray;
        InstructionHandle instructionHandle = codeSequence.getCurrent();
        int n = 0;
        while (n < this.quads.length) {
            codeSequence.plantQuadruple(this.quads[n]);
            ++n;
        }
        this.setMarked(true);
        if (this.next != null) {
            QQuadruple[] qQuadrupleArray = this.getTransition(this.next);
            if (qQuadrupleArray != null && qQuadrupleArray.length != 0) {
                basicBlockArray = new BasicBlock(-1);
                basicBlockArray.setBody(qQuadrupleArray);
                codeSequence.plantBasicBlock((BasicBlock)basicBlockArray);
            }
            codeSequence.jumpToBasicBlock(this.next);
        }
        this.firstInstruction = instructionHandle == null ? codeSequence.getCodeStart() : instructionHandle.getNext();
        QNode qNode = this.getLastNode();
        if (qNode != null && qNode.isJump()) {
            basicBlockArray = qNode.getJump().getTarget();
            codeSequence.plantBasicBlock((BasicBlock)basicBlockArray, qNode.getInstruction().getJump(), this.getTransition((BasicBlock)basicBlockArray));
        } else if (qNode != null && qNode.isSwitch()) {
            basicBlockArray = qNode.getSwitch().getTargets();
            this.optimizeOrder(basicBlockArray, codeSequence);
        }
    }

    public void resolveJump() {
        InstructionHandle instructionHandle = this.insns[this.insns.length - 1];
        if (instructionHandle.isJump()) {
            InstructionHandle instructionHandle2 = instructionHandle.getTarget();
            BasicBlock basicBlock = ControlFlow.findBasicBlock(instructionHandle2);
            instructionHandle.getJump().setTarget(basicBlock);
            if (instructionHandle.getJump().canComplete()) {
                this.next = ControlFlow.findBasicBlock(instructionHandle.getNext());
            }
        } else if (instructionHandle.getInstruction() instanceof SwitchInstruction) {
            SwitchInstruction switchInstruction = (SwitchInstruction)instructionHandle.getInstruction();
            int n = -1;
            while (n < switchInstruction.getSwitchCount()) {
                switchInstruction.setTarget(ControlFlow.findBasicBlock((InstructionHandle)switchInstruction.getTarget(n)), n);
                ++n;
            }
        } else if (instructionHandle.getInstruction().canComplete() && instructionHandle.getNext() != null) {
            this.next = ControlFlow.findBasicBlock(instructionHandle.getNext());
        }
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public String toString() {
        return "BasicBlock " + this.pos;
    }

    private void optimizeOrder(BasicBlock[] basicBlockArray, CodeSequence codeSequence) {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < basicBlockArray.length) {
            if (basicBlockArray[n3].getPosition() > n2) {
                n2 = basicBlockArray[n3].getPosition();
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < basicBlockArray.length) {
            int n4 = Integer.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            while (n6 < basicBlockArray.length) {
                if (basicBlockArray[n6].getPosition() < n4 && basicBlockArray[n6].getPosition() > n) {
                    n4 = basicBlockArray[n6].getPosition();
                    n5 = n6;
                }
                ++n6;
            }
            n = n4;
            codeSequence.plantBasicBlock(basicBlockArray[n5], n3 == basicBlockArray.length - 1 ? Integer.MAX_VALUE : n2);
            ++n3;
        }
    }

    private BasicBlock[] buildSuccessorList() {
        if (this.successors != null) {
            return this.successors;
        }
        int n = this.next == null ? 0 : 1;
        QNode qNode = this.getLastNode();
        if (qNode != null && qNode.isJump()) {
            ++n;
        } else if (qNode != null && qNode.isSwitch()) {
            n += ((SwitchInstruction)qNode.getInstruction().getInstruction()).getSwitchCount();
        }
        this.successors = new BasicBlock[n];
        if (this.next != null) {
            this.successors[--n] = this.next;
        }
        if (qNode != null && qNode.isJump()) {
            this.successors[--n] = qNode.getJump().getTarget();
        } else if (qNode != null && qNode.isSwitch()) {
            SwitchInstruction switchInstruction = (SwitchInstruction)qNode.getInstruction().getInstruction();
            int n2 = -1;
            while (n2 < switchInstruction.getSwitchCount() - 1) {
                this.successors[--n] = (BasicBlock)((SwitchInstruction)qNode.getInstruction().getInstruction()).getTarget(n2);
                ++n2;
            }
        }
        return this.successors;
    }

    private QQuadruple[] getTransition(BasicBlock basicBlock) {
        int n = 0;
        while (n < this.successors.length) {
            if (this.successors[n] == basicBlock) {
                return this.successorAccess[n];
            }
            ++n;
        }
        throw new InconsistencyException();
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
    }

    public void attachTo(AccessorContainer accessorContainer) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BasicBlock(int n) {
        this.pos = n;
    }
}

