/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.AliasConstraint;
import gnu.mapping.Binding;
import gnu.mapping.Binding2;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.SFormat;
import gnu.mapping.Values;
import java.io.PrintWriter;
import kawa.lang.Macro;

public class SetExp
extends Expression {
    private int flags;
    String name;
    public Declaration binding;
    Expression new_value;
    private static int DEFINING_FLAG = 1;
    private static int GLOBAL_FLAG = 2;
    public static int PREFER_BINDING2 = 4;
    private static int PROCEDURE = 8;
    private static int SET_IF_UNBOUND = 16;
    private static int HAS_VALUE = 32;
    static Method setMethod = null;

    public SetExp(Declaration declaration, Expression expression) {
        this.binding = declaration;
        this.name = declaration.getName();
        this.new_value = expression;
        if ("%do%loop".equals(declaration.getName()) && expression instanceof LambdaExp && !Compilation.usingCPStyle()) {
            ((LambdaExp)expression).setInlineOnly(true);
        }
    }

    public SetExp(String string, Expression expression) {
        this.name = string;
        this.new_value = expression;
    }

    public void compile(Compilation compilation, Target target) {
        boolean bl;
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        boolean bl2 = bl = this.getHasValue() && !(target instanceof IgnoreTarget);
        if (bl && this.binding != null) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (this.binding != null && !this.binding.isPrivate() && this.binding.context instanceof ModuleExp && this.binding.getValue() instanceof LambdaExp && ((LambdaExp)this.binding.getValue()).getName() != null && this.binding.getValue() == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(compilation);
        } else if (this.binding == null || !(this.binding.context instanceof ModuleExp) || !(this.new_value instanceof QuoteExp) || this.binding.isPrivate() || compilation.immediate || this.binding.getValue() == null) {
            if (this.binding instanceof Macro && this.binding.context instanceof ModuleExp && ((Macro)this.binding).expander instanceof LambdaExp && !this.binding.isPrivate()) {
                LambdaExp lambdaExp = (LambdaExp)((Macro)this.binding).expander;
                if (!lambdaExp.isHandlingTailCalls()) {
                    lambdaExp.flags |= 0x100;
                    lambdaExp.compileAsMethod(compilation);
                    compilation.applyMethods.addElement(lambdaExp);
                }
                this.binding.makeField(compilation, this.new_value);
            } else if (this.binding != null) {
                Declaration declaration = this.binding;
                if (!this.isDefining()) {
                    declaration = Declaration.followAliases(declaration);
                }
                if (declaration.ignorable()) {
                    this.new_value.compile(compilation, Target.Ignore);
                } else if (this.binding.isAlias() && this.isDefining()) {
                    if (this.binding.isPublic() || !(this.binding.getValue() instanceof ReferenceExp)) {
                        this.binding.load(compilation);
                        this.new_value.compile(compilation, Target.pushObject);
                        Method method = ClassType.make("gnu.mapping.AliasConstraint").getDeclaredMethod("define", 2);
                        codeAttr.emitInvokeStatic(method);
                    }
                } else if (declaration.isIndirectBinding() && (!this.isDefining() || declaration.isPublic())) {
                    declaration.load(compilation);
                    this.new_value.compile(compilation, Target.pushObject);
                    if (setMethod == null) {
                        setMethod = Compilation.typeLocation.addMethod("set", Compilation.apply1args, Type.void_type, 17);
                    }
                    codeAttr.emitInvokeVirtual(setMethod);
                } else if (declaration.isFluid()) {
                    declaration.load(compilation);
                    this.new_value.compile(compilation, Type.pointer_type);
                    codeAttr.emitPutField(FluidLetExp.valueField);
                } else if (declaration.isSimple()) {
                    Variable variable;
                    this.new_value.compile(compilation, declaration.getType());
                    if (bl) {
                        codeAttr.emitDup(1, 0);
                    }
                    if ((variable = declaration.getVariable()) == null) {
                        variable = declaration.allocateVariable(codeAttr);
                    }
                    codeAttr.emitStore(variable);
                } else {
                    Field field = declaration.field;
                    if (!field.getStaticFlag()) {
                        declaration.loadOwningObject(compilation);
                    }
                    this.new_value.compile(compilation, field.getType());
                    if (field.getStaticFlag()) {
                        codeAttr.emitPutStatic(field);
                    } else {
                        codeAttr.emitPutField(field);
                    }
                }
            } else {
                compilation.compileConstant(this.name);
                this.new_value.compile(compilation, Target.pushObject);
                if (bl) {
                    codeAttr.emitDup(1, 1);
                }
                Method method = this.isDefining() ? (this.isFuncDef() && compilation.getInterpreter().hasSeparateFunctionNamespace() ? Compilation.defineFunctionMethod : Compilation.defineGlobalMethod) : Compilation.putGlobalMethod;
                codeAttr.emitInvokeStatic(method);
            }
        }
        if (bl) {
            target.compileFromStack(compilation, this.getType());
        } else {
            compilation.compileConstant(Values.empty, target);
        }
    }

    public Object eval(Environment environment) {
        if (this.isSetIfUnbound()) {
            Binding binding = environment.getBinding(this.name);
            if (!binding.isBound()) {
                binding.set(this.new_value.eval(environment));
            }
            if (this.getHasValue()) {
                return this.name;
            }
            return Interpreter.getInterpreter().noValue();
        }
        Object object2 = this.new_value.eval(environment);
        if (this.binding != null && (!this.binding.isStatic() || this.binding.isPrivate())) {
            throw new Error("internal error - SetExp.eval with lexical binding");
        }
        if (this.isDefining()) {
            if (this.binding != null && this.binding.isAlias()) {
                AliasConstraint.define(environment.getBinding(this.name), (Location)object2);
            } else {
                environment.define(this.name, object2);
            }
        } else {
            Binding binding;
            Binding binding2 = binding = this.getFlag(PREFER_BINDING2) ? Binding2.getBinding2(environment, this.name) : environment.lookup(this.name);
            if (binding != null) {
                environment.put(this.name, object2);
            } else {
                environment.define(this.name, object2);
            }
        }
        return this.getHasValue() ? object2 : Interpreter.getInterpreter().noValue();
    }

    public final boolean getHasValue() {
        return (this.flags & HAS_VALUE) != 0;
    }

    public final Type getType() {
        return !this.getHasValue() ? Type.void_type : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    public final boolean isDefining() {
        return (this.flags & DEFINING_FLAG) != 0;
    }

    public final boolean isFuncDef() {
        return (this.flags & PROCEDURE) != 0;
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & SET_IF_UNBOUND) != 0;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this.isDefining() ? "(#%define " : "(#%set! ");
        SFormat.print(this.name, printWriter);
        printWriter.print(" ");
        this.new_value.print(printWriter);
        printWriter.print(")");
    }

    public final void setDefining(boolean bl) {
        this.flags = bl ? (this.flags |= DEFINING_FLAG) : (this.flags &= ~DEFINING_FLAG);
    }

    public final void setFuncDef(boolean bl) {
        this.flags = bl ? (this.flags |= PROCEDURE) : (this.flags &= ~PROCEDURE);
    }

    public final void setHasValue(boolean bl) {
        this.flags = bl ? (this.flags |= HAS_VALUE) : (this.flags &= ~HAS_VALUE);
    }

    public final void setSetIfUnbound(boolean bl) {
        this.flags = bl ? (this.flags |= SET_IF_UNBOUND) : (this.flags &= ~SET_IF_UNBOUND);
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkSetExp(this);
    }
}

