/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final int NUM_MANTISSA_BITS = 23;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int MANTISSA_MASK = 0x7FFFFF;
    private static final int NAN_BITS = 2143289344;
    private static final int POSITIVE_INFINITY_BITS = 2139095040;
    private static final int NEGATIVE_INFINITY_BITS = -8388608;
    private static final int MIN_VALUE_BITS = 1;
    private static final int MAX_VALUE_BITS = 0x7F7FFFFF;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final Class TYPE = Class.getPrimitiveClass("float");
    private static final long serialVersionUID = -2671257302660747028L;
    private final float value;

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)object).value);
    }

    public int compareTo(Object object) {
        int n;
        int n2 = Float.floatToIntBits(this.value);
        return n2 < (n = Float.floatToIntBits(((Float)object).value)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public static String toString(float f) {
        int n;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int n2 = Float.floatToRawIntBits(f);
        if ((n2 & 0x7F800000) == 0) {
            int n3 = 22;
            while (n3 > 0 && (1 << n3 & n2) == 0) {
                --n3;
            }
            n = Double.bitsToDecimal[n3];
        } else {
            n = Double.bitsToDecimal[22];
        }
        return Double.toStringWithPrecision(f, ++n);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public static int floatToIntBits(float f) {
        int n = Float.floatToRawIntBits(f);
        return Float.isNaN(n) ? 2143289344 : n;
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(Float.floatToRawIntBits(f));
    }

    public boolean isNaN() {
        return Float.isNaN(Float.floatToRawIntBits(this.value));
    }

    private static boolean isNaN(int n) {
        return (n & 0x7F800000) == 2139095040 && (n & 0x7FFFFF) != 0;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Float(Double.valueOf0(string));
    }

    public static float parseFloat(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (float)Double.valueOf0(string);
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        this.value = Float.valueOf((String)string).value;
    }
}

